/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.types.LocalizeUtil;
import ch.elexis.core.types.RelationshipType;
import ch.elexis.data.BezugsKontaktRelation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Messages;
import ch.elexis.data.PersistentObject;
import org.eclipse.emf.common.util.Enumerator;

public class BezugsKontakt
extends PersistentObject {
    public static final String RELATION = "Bezug";
    public static final String OTHER_ID = "otherID";
    public static final String MY_ID = "myID";
    public static final String FLD_MY_RTYPE = "myRType";
    public static final String FLD_OTHER_RTYPE = "otherRType";
    public static final String TABLENAME = "KONTAKT_ADRESS_JOINT";

    static {
        BezugsKontakt.addMapping(TABLENAME, MY_ID, OTHER_ID, RELATION, FLD_MY_RTYPE, FLD_OTHER_RTYPE);
    }

    public BezugsKontakt(Kontakt kontakt, Kontakt adr, String bezug) {
        this(kontakt, adr, new BezugsKontaktRelation(bezug, RelationshipType.AGENERIC, RelationshipType.AGENERIC));
    }

    public BezugsKontakt(Kontakt kontakt, Kontakt adr, BezugsKontaktRelation bezugsKontaktType) {
        this.create(null);
        this.set(new String[]{MY_ID, OTHER_ID, RELATION, FLD_MY_RTYPE, FLD_OTHER_RTYPE}, kontakt.getId(), adr.getId(), bezugsKontaktType.getName(), String.valueOf(bezugsKontaktType.getDestRelationType().getValue()), String.valueOf(bezugsKontaktType.getSrcRelationType().getValue()));
    }

    public void updateRelation(BezugsKontaktRelation bezugsKontaktRelation) {
        this.set(new String[]{RELATION, FLD_MY_RTYPE, FLD_OTHER_RTYPE}, bezugsKontaktRelation.getName(), String.valueOf(bezugsKontaktRelation.getDestRelationType().getValue()), String.valueOf(bezugsKontaktRelation.getSrcRelationType().getValue()));
    }

    @Override
    public String getLabel() {
        Kontakt k = Kontakt.load(this.get(OTHER_ID));
        if (k.isValid()) {
            String rel = this.get(RELATION);
            if (rel.isEmpty() && !(rel = this.get(FLD_OTHER_RTYPE)).isEmpty()) {
                try {
                    RelationshipType type = RelationshipType.get((int)Integer.parseInt(rel));
                    if (type != null) {
                        rel = LocalizeUtil.getLocaleText((Enumerator)type);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return rel + ": " + k.getLabel();
        }
        return Messages.BezugsKontakt_ContactDoesntExist;
    }

    public static BezugsKontakt load(String id) {
        return new BezugsKontakt(id);
    }

    public Kontakt getBezugsKontakt() {
        return Kontakt.load(this.get(OTHER_ID));
    }

    public String getBezug() {
        return BezugsKontakt.checkNull(this.get(RELATION));
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected BezugsKontakt() {
    }

    protected BezugsKontakt(String id) {
        super(id);
    }
}

