/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.cache;

import ch.elexis.core.data.cache.IPersistentObjectCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;

public class MultiGuavaCache<K>
implements IPersistentObjectCache<K> {
    private Cache<K, Object> shortTermCache;
    private Cache<K, Object> longTermCache;
    private static boolean STAT_ENABLED = false;

    public MultiGuavaCache(long duration, TimeUnit unit) {
        if (STAT_ENABLED) {
            this.shortTermCache = CacheBuilder.newBuilder().softValues().recordStats().expireAfterWrite(duration, unit).build();
            this.longTermCache = CacheBuilder.newBuilder().softValues().recordStats().maximumSize(Long.MAX_VALUE).build();
        } else {
            this.shortTermCache = CacheBuilder.newBuilder().softValues().expireAfterWrite(duration, unit).build();
            this.longTermCache = CacheBuilder.newBuilder().softValues().maximumSize(Long.MAX_VALUE).build();
        }
    }

    @Override
    public void put(K key, Object object, int timeToCacheInSeconds) {
        if (key == null || object == null) {
            return;
        }
        if (timeToCacheInSeconds <= 15) {
            this.shortTermCache.put(key, object);
        } else {
            this.longTermCache.put(key, object);
        }
    }

    @Override
    public Object get(K key, int cacheTime) {
        if (cacheTime <= 15) {
            return this.shortTermCache.getIfPresent(key);
        }
        return this.longTermCache.getIfPresent(key);
    }

    @Override
    public Object get(K key) {
        Object ret = this.shortTermCache.getIfPresent(key);
        if (ret != null) {
            return ret;
        }
        return this.longTermCache.getIfPresent(key);
    }

    @Override
    public void remove(K key) {
        this.shortTermCache.invalidate(key);
        this.longTermCache.invalidate(key);
    }

    @Override
    public void clear() {
        this.shortTermCache.invalidateAll();
        this.longTermCache.invalidateAll();
    }

    @Override
    public void stat() {
        if (STAT_ENABLED) {
            CacheStats shortStats = this.shortTermCache.stats();
            CacheStats longStats = this.longTermCache.stats();
            System.out.println("--------- GUAVA CACHE Statistics ---------");
            System.out.println("|>--- SHORT-TERM");
            System.out.println("| Hits (count/rate): " + shortStats.hitCount() + " / " + String.format("%.2f%%", shortStats.hitRate() * 100.0));
            System.out.println("| Misses (count/rate): " + shortStats.missCount() + " / " + String.format("%.2f%%", shortStats.missRate() * 100.0));
            System.out.println("|>--- LONG-TERM ");
            System.out.println("| Hits (count/rate): " + longStats.hitCount() + " / " + String.format("%.2f%%", longStats.hitRate() * 100.0));
            System.out.println("| Misses (count/rate): " + longStats.missCount() + " / " + String.format("%.2f%%", longStats.missRate() * 100.0));
            System.out.println("------------------------------------------");
        }
    }

    @Override
    public void purge() {
        this.clear();
    }

    @Override
    public void reset() {
        this.clear();
    }
}

