/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.OutputLog;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Sticker;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

public class Brief
extends PersistentObject {
    public static final String FLD_MIME_TYPE = "MimeType";
    public static final String FLD_DATE_MODIFIED = "modifiziert";
    public static final String FLD_DATE = "Datum";
    public static final String FLD_TYPE = "Typ";
    public static final String FLD_KONSULTATION_ID = "BehandlungsID";
    public static final String FLD_DESTINATION_ID = "DestID";
    public static final String FLD_SENDER_ID = "AbsenderID";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_SUBJECT = "Betreff";
    public static final String FLD_NOTE = "note";
    public static final String FLD_GELOESCHT = "geloescht";
    public static final String TABLENAME = "BRIEFE";
    public static final String TEMPLATE = "Vorlagen";
    public static final String AUZ = "AUF-Zeugnis";
    public static final String RP = "Rezept";
    public static final String UNKNOWN = "Allg.";
    public static final String LABOR = "Labor";
    public static final String BESTELLUNG = "Bestellung";
    public static final String RECHNUNG = "Rechnung";
    public static final String MIMETYPE_OO2 = "application/vnd.oasis.opendocument.text";
    public static final String SYS_TEMPLATE = "SYS";
    private Sticker dontAskForAddresseeSticker;

    static {
        Brief.addMapping(TABLENAME, FLD_SUBJECT, FLD_PATIENT_ID, "Datum=S:D:Datum", FLD_SENDER_ID, FLD_DESTINATION_ID, FLD_KONSULTATION_ID, FLD_TYPE, "modifiziert=S:D:modifiziert", FLD_GELOESCHT, FLD_MIME_TYPE, "gedruckt=S:D:gedruckt", "Path", FLD_NOTE);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected Brief() {
    }

    protected Brief(String id) {
        super(id);
    }

    public static Brief load(String id) {
        return new Brief(id);
    }

    public IDocument toIDocument() {
        if (TEMPLATE.equals(this.getTyp())) {
            return (IDocument)CoreModelServiceHolder.get().load(this.getId(), IDocumentTemplate.class).orElseThrow(() -> new IllegalStateException("Could not convert Brief [" + this.getId() + "]"));
        }
        return (IDocument)CoreModelServiceHolder.get().load(this.getId(), IDocumentLetter.class).orElseThrow(() -> new IllegalStateException("Could not convert Brief [" + this.getId() + "]"));
    }

    public Brief(String Betreff, TimeTool Datum, Kontakt Absender, Kontakt dest, Konsultation bh, String typ) {
        try {
            super.create(null);
            if (Datum == null) {
                Datum = new TimeTool();
            }
            String pat = "";
            String bhdl = "";
            if (bh != null) {
                bhdl = bh.getId();
                pat = bh.getFall().getPatient().getId();
            }
            String dst = "";
            if (dest != null) {
                dst = dest.getId();
            }
            String dat = Datum.toString(13);
            this.set(new String[]{FLD_SUBJECT, FLD_PATIENT_ID, FLD_DATE, FLD_SENDER_ID, FLD_DATE_MODIFIED, FLD_DESTINATION_ID, FLD_KONSULTATION_ID, FLD_TYPE, FLD_GELOESCHT}, Betreff, pat, dat, Absender == null ? "" : Absender.getId(), dat, dst, bhdl, typ, "0");
        }
        catch (Throwable ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public void setPatient(Person k) {
        this.set(FLD_PATIENT_ID, k.getId());
    }

    public void setTyp(String typ) {
        this.set(FLD_TYPE, typ);
    }

    public String getTyp() {
        String t = this.get(FLD_TYPE);
        if (t == null) {
            return "Brief";
        }
        return t;
    }

    public boolean save(String cnt) {
        return this.save(cnt.getBytes(), "txt");
    }

    public boolean save(byte[] in, String mimetype) {
        block12: {
            Throwable throwable = null;
            Object var4_6 = null;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(in);
            try {
                IDocument iDocument = this.toIDocument();
                iDocument.setMimeType(mimetype);
                iDocument.setContent((InputStream)inputStream);
                CoreModelServiceHolder.get().save((Identifiable)iDocument);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Error saving content of Brief [{}]", (Object)this.getId(), (Object)e);
                    return false;
                }
            }
            inputStream.close();
        }
        return true;
    }

    public byte[] loadBinary() {
        byte[] content = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = this.toIDocument().getContent();){
                content = IOUtils.toByteArray((InputStream)is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error loading content of Brief [{}]", (Object)this.getId(), (Object)e);
        }
        return content;
    }

    public String read() {
        return new String(this.loadBinary());
    }

    public String getMimeType() {
        String gm = this.get(FLD_MIME_TYPE);
        if (StringTool.isNothing((Object)gm)) {
            return MIMETYPE_OO2;
        }
        return gm;
    }

    public static boolean canHandle(String mimetype) {
        return true;
    }

    @Override
    public boolean delete() {
        Konsultation kons;
        String konsID = this.get(FLD_KONSULTATION_ID);
        if (!StringTool.isNothing((Object)konsID) && !konsID.equals(SYS_TEMPLATE) && (kons = Konsultation.load(konsID)) != null && kons.exists() && kons.isEditable(false)) {
            kons.removeXRef("ch.elexis.text.DocXRef", this.getId());
        }
        CoreModelServiceHolder.get().delete((Deleteable)this.toIDocument());
        return super.delete();
    }

    public OutputLog logOutput(IOutputter outputter) {
        return new OutputLog(this, outputter);
    }

    public void removeContent() {
        IDocument iDocument = this.toIDocument();
        iDocument.setContent(null);
        CoreModelServiceHolder.get().save((Identifiable)iDocument);
    }

    public String getBetreff() {
        return Brief.checkNull(this.get(FLD_SUBJECT));
    }

    public void setBetreff(String nBetreff) {
        this.set(FLD_SUBJECT, nBetreff);
    }

    public String getDatum() {
        return new TimeTool(this.get(FLD_DATE)).toString(4);
    }

    public Kontakt getAdressat() {
        String dest = this.get(FLD_DESTINATION_ID);
        return dest == null ? null : Kontakt.load(dest);
    }

    public void setAdressat(String adressatId) {
        this.set(FLD_DESTINATION_ID, adressatId);
    }

    public Person getPatient() {
        Person pat = Person.load(this.get(FLD_PATIENT_ID));
        if (pat != null && pat.state() > 1) {
            return pat;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return Brief.checkNull(this.get(FLD_DATE)) + " " + Brief.checkNull(this.get(FLD_SUBJECT));
    }

    public boolean isAskForAddressee() {
        return !this.getStickers().stream().filter(s -> ((Sticker)s).get("Name").equals("brief_dontaskforaddressee-*-&")).findFirst().isPresent();
    }
}

