/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Test_Query
extends AbstractPersistentObjectTest {
    static final String FIRST_NAME = "first";
    static final String SECOND_NAME = "second";
    static final String THIRD_NAME = "third";
    private Organisation org1;
    private Organisation org2;
    private Organisation org3;

    @Before
    public void before() {
        this.org1 = new Organisation(SECOND_NAME, "second_zusatz");
        this.org2 = new Organisation(FIRST_NAME, "first_zusatz");
        this.org3 = new Organisation(THIRD_NAME, "third_zusatz");
    }

    @After
    public void after() {
        this.org1.delete();
        this.org2.delete();
        this.org3.delete();
    }

    @Test
    public void testConstructor() {
        Query query = new Query(Organisation.class);
        query.clear();
        query = new Query(Organisation.class, "Bezeichnung1", FIRST_NAME);
        query.clear();
    }

    @Test
    public void testConstructorFail() {
        try {
            new Query(PersistentObjectImpl.class);
            Assert.fail((String)"Expected Exception not thrown!");
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        try {
            new Query(PersistentObjectImpl.class, "", "");
            Assert.fail((String)"Expected Exception not thrown!");
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPreparedStatement() {
        PreparedStatement ps = this.getLink().getPreparedStatement("SELECT Bezeichnung1 FROM KONTAKT");
        Query query = new Query(Organisation.class);
        ArrayList result = query.execute(ps, new String[0]);
        int nrOrgs = result.size();
        Organisation organisation = new Organisation("NeueOrganistation", "Zusatznamen2");
        result = query.execute(ps, new String[0]);
        this.getLink().releasePreparedStatement(ps);
        Assert.assertEquals((long)(nrOrgs + 1), (long)result.size());
        organisation.delete();
    }

    @Test
    public void testOrderBy() {
        Query query = new Query(Organisation.class);
        query.clear();
        query.orderBy(false, new String[]{"Bezeichnung1"});
        List result = query.execute();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)FIRST_NAME, (Object)((Organisation)result.get(0)).get("Bezeichnung1"));
        Assert.assertEquals((Object)SECOND_NAME, (Object)((Organisation)result.get(1)).get("Bezeichnung1"));
        Assert.assertEquals((Object)THIRD_NAME, (Object)((Organisation)result.get(2)).get("Bezeichnung1"));
        query.clear();
        query.orderBy(true, new String[]{"Bezeichnung1"});
        result = query.execute();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)FIRST_NAME, (Object)((Organisation)result.get(2)).get("Bezeichnung1"));
        Assert.assertEquals((Object)SECOND_NAME, (Object)((Organisation)result.get(1)).get("Bezeichnung1"));
        Assert.assertEquals((Object)THIRD_NAME, (Object)((Organisation)result.get(0)).get("Bezeichnung1"));
    }

    @Test
    public void testOrderByReverse() {
        Query query = new Query(Organisation.class);
        query.clear();
        query.orderBy(true, new String[]{"Bezeichnung1"});
        List result = query.execute();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)FIRST_NAME, (Object)((Organisation)result.get(2)).get("Bezeichnung1"));
        Assert.assertEquals((Object)SECOND_NAME, (Object)((Organisation)result.get(1)).get("Bezeichnung1"));
        Assert.assertEquals((Object)THIRD_NAME, (Object)((Organisation)result.get(0)).get("Bezeichnung1"));
    }

    @Test
    public void testExecute() {
        Query query = new Query(Organisation.class);
        query.clear();
        query.add("Bezeichnung1", "=", FIRST_NAME);
        List result = query.execute();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Ignore
    public void testExecuteOnDBConnection() throws IOException {
        Query query = new Query(Organisation.class);
        query.clear();
        query.add("Bezeichnung1", "=", FIRST_NAME);
        DBConnection connection = new DBConnection();
        connection.setDBConnectString("jdbc:h2:mem:test_query_mem");
        connection.setDBUser("sa");
        connection.setDBPassword("");
        Assert.assertTrue((boolean)connection.connect());
        List result = query.execute(connection);
        Assert.assertEquals((long)0L, (long)result.size());
        DBConnection initialConnection = PersistentObject.getDefaultConnection();
        PersistentObject.connect((DBConnection)connection);
        new Organisation(FIRST_NAME, "orgzusatz1");
        result = query.execute(connection);
        Assert.assertEquals((long)1L, (long)result.size());
        PersistentObject.disconnect();
        PersistentObject.connect((DBConnection)initialConnection);
    }

    @Test
    public void testQueryExpression() {
        PreparedStatement ps = this.getLink().prepareStatement("SELECT Bezeichnung1 FROM KONTAKT");
        Query query = new Query(Organisation.class);
        ArrayList result = query.execute(ps, new String[0]);
        int nrOrgs = result.size();
        System.out.println("Before creating new organistaion found " + nrOrgs + " Organisation");
        for (String s : result) {
            System.out.println("Organisation: found " + s);
        }
        Organisation organisation = new Organisation("NeueOrganistation", "Zusatznamen2");
        result = query.execute(ps, new String[0]);
        System.out.println("After creating new organistaion found " + result.size() + " Organisation");
        for (String s : result) {
            System.out.println("Organisation: found " + s);
        }
        Assert.assertEquals((long)(nrOrgs + 1), (long)result.size());
        organisation.delete();
    }

    @Test
    public void testQueryNotNullExpression() {
        this.executeStatement("DELETE FROM ARTIKEL WHERE 1=1");
        Artikel art = new Artikel("TestARtikel", "Eigenartikel");
        art.set("SubID", "notNull");
        new Artikel("TestARtikel", "Eigenartikel");
        Query qbe = new Query(Artikel.class);
        qbe.startGroup();
        qbe.add("SubID", "<>", null);
        qbe.or();
        qbe.add("EAN", "<>", null);
        qbe.add("ExtID", "<>", null);
        qbe.endGroup();
        List execute = qbe.execute();
        Assert.assertEquals((long)1L, (long)execute.size());
        art.delete();
    }

    @Test
    public void testQueryWithDefinedConditionEqualsAddedCondition() {
        Query qbe = new Query(Artikel.class);
        qbe.add("SubID", "=", "17");
        Query qbe2 = new Query(Artikel.class, "SubID", "17");
        Assert.assertEquals((Object)qbe.getActualQuery(), (Object)qbe2.getActualQuery());
    }

    @Test
    public void testQueryWithApostrophe() {
        Patient testPatient = new Patient("D'Andrea", "Max", "1.1.2000", "m");
        Assert.assertEquals((Object)"D'Andrea", (Object)testPatient.getName());
        Query qre = new Query(Person.class);
        qre.add("Bezeichnung1", "=", "D'Andrea");
        List result = qre.execute();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"D'Andrea", (Object)((Person)result.get(0)).getName());
        testPatient.delete();
    }

    @Test
    public void testQueryMappedExpression() {
        String MappingName = "TitelSuffix";
        PreparedStatement ps = this.getLink().getPreparedStatement("SELECT Bezeichnung1 FROM KONTAKT");
        Query query = new Query(Organisation.class);
        query.clear();
        query.add("Land", "<=", "TitelSuffix");
        System.out.println("Must query via TitelSuffix. Fieldname is Versicherungsart");
        System.out.println("getActualQuery: " + query.getActualQuery());
        ArrayList result = query.execute(ps, new String[0]);
        Assert.assertTrue((result.size() >= 3 ? 1 : 0) != 0);
        Query query2 = new Query(Organisation.class);
        query2.clear();
        query2.add("Land", ">", "TitelSuffix");
        List result2 = query2.execute();
        Assert.assertEquals((long)0L, (long)result2.size());
    }

    private class PersistentObjectImpl
    extends PersistentObject {
        private PersistentObjectImpl() {
        }

        public String getTestGet() {
            return "test";
        }

        public String getLabel() {
            return null;
        }

        protected String getTableName() {
            return null;
        }
    }
}

