/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.service.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.extension.ICoreOperationAdvisor;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.util.IRunnableWithProgress;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ILoginContributor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TestOnlyCoreOperationAdvisor
implements ICoreOperationAdvisor {
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE)
    private List<ILoginContributor> loginServices;
    private Logger logger;

    @Activate
    public void activate() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void requestDatabaseConnectionConfiguration() {
    }

    public void requestInitialMandatorConfiguration() {
    }

    public void adaptForUser() {
    }

    public boolean openQuestion(String title, String message) {
        System.out.println(this.getClass().getName() + "#openQuestion - answer=false title=[" + title + "]");
        this.logger.warn("openQuestion - answer=false [{} - {}]", (Object)title, (Object)message);
        return false;
    }

    public void openInformation(String title, String message) {
        System.out.println(this.getClass().getName() + "#openInformation - title=[" + title + "]");
        this.logger.info("openInformation [{} - {}]", (Object)title, (Object)message);
    }

    public boolean performLogin(Object shell) {
        IUser user;
        System.out.println("ATTENTION - login handled by " + this.getClass().getName());
        CoreHub.logoffAnwender();
        try {
            user = this.loginServices.get(0).performLogin(null);
        }
        catch (LoginException e) {
            e.printStackTrace();
            return false;
        }
        if (user != null && user.isActive()) {
            CoreModelServiceHolder.get().refresh((Identifiable)user, true);
            if (user.getAssignedContact() != null) {
                CoreModelServiceHolder.get().refresh((Identifiable)user.getAssignedContact(), true);
            }
            ContextServiceHolder.get().setActiveUser(user);
            CoreOperationAdvisorHolder.get().adaptForUser();
            CoreHub.heart.resume(true);
            return true;
        }
        return false;
    }

    public String getInitialPerspective() {
        return null;
    }

    public boolean performDatabaseUpdate(String[] array, String pluginId) {
        return false;
    }

    public void showProgress(IRunnableWithProgress irwp, String taskName) {
    }
}

