/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.views;

import ch.elexis.core.ui.UiDesk;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import waelti.statistics.actions.ExportAction;
import waelti.statistics.actions.NewQueryAction;
import waelti.statistics.actions.RefreshQueryAction;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.views.OptionPanel;
import waelti.statistics.views.ResultTable;

public class OutputView
extends ViewPart {
    private Composite parent;
    private OptionPanel queryOptions;
    private AbstractQuery query;
    private Label header;
    private ResultTable resultView;
    private NewQueryAction newQueryAction;
    private RefreshQueryAction refreshQueryAction;
    private ExportAction exportAction;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parent.setLayout((Layout)new GridLayout());
        this.parent.setBackground(UiDesk.getColor((String)"weiss"));
        this.makeAction();
        this.contributeAction();
        this.initHeader("Keine Auswertung ausgew\u00e4hlt.");
    }

    private void initHeader(String labelText) {
        this.header = new Label(this.parent, 64);
        this.header.setText(labelText);
        this.header.setFont(new Font((Device)UiDesk.getDisplay(), "Helvetica", 11, 1));
        this.header.setBackground(UiDesk.getColor((String)"weiss"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.header.setLayoutData((Object)data);
    }

    private void makeAction() {
        this.newQueryAction = new NewQueryAction(this);
        this.refreshQueryAction = new RefreshQueryAction(this);
        this.refreshQueryAction.setEnabled(false);
        this.exportAction = new ExportAction(this);
        this.exportAction.setEnabled(false);
    }

    private void contributeAction() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.refreshQueryAction);
        manager.add((IAction)this.newQueryAction);
    }

    public void setFocus() {
    }

    public void setHeader(String headerText) {
        this.header.setText(headerText);
        this.header.setFont(new Font((Device)UiDesk.getDisplay(), "Helvetica", 11, 1));
        this.parent.layout();
    }

    public void setButtonsEnabled(boolean enabled) {
        this.newQueryAction.setEnabled(enabled);
        this.refreshQueryAction.setEnabled(enabled);
        this.exportAction.setEnabled(enabled);
    }

    public NewQueryAction getNewQueryAction() {
        return this.newQueryAction;
    }

    public RefreshQueryAction getRefreshQueryAction() {
        return this.refreshQueryAction;
    }

    public ResultTable getResultView() {
        return this.resultView;
    }

    public void setResultView(ResultTable resultView) {
        if (this.resultView != null) {
            this.resultView.dispose();
        }
        this.resultView = resultView;
    }

    public Composite getParent() {
        return this.parent;
    }

    public AbstractQuery getQuery() {
        return this.query;
    }

    public void setQuery(AbstractQuery query) {
        this.query = query;
    }

    public OptionPanel getQueryOptions() {
        return this.queryOptions;
    }

    public void setQueryOptions(OptionPanel queryOptions) {
        if (this.queryOptions != null) {
            this.queryOptions.dispose();
        }
        this.queryOptions = queryOptions;
    }
}

