/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.views;

import ch.elexis.core.ui.util.SWTHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.queries.SetDataException;
import waelti.statistics.queries.annotations.GetProperty;
import waelti.statistics.queries.annotations.SetProperty;

public class OptionPanel
extends Composite {
    private Map<String, Text> fieldMap = new TreeMap<String, Text>();
    private AbstractQuery query;
    private Color background;

    public OptionPanel(Composite parent) {
        super(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.background = parent.getBackground();
    }

    public OptionPanel(Composite parent, Color background) {
        this(parent);
        this.background = background;
        this.setBackground(background);
    }

    public void updateContent(AbstractQuery selectedQuery) {
        this.query = selectedQuery;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.fieldMap = new TreeMap<String, Text>();
        this.createQueryField();
        this.layout();
    }

    private void createQueryField() {
        ArrayList<Method> getterMethodList = new ArrayList<Method>();
        Method[] methodArray = ((Object)((Object)this.query)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(GetProperty.class)) {
                getterMethodList.add(method);
            }
            ++n2;
        }
        this.sortMethodList(getterMethodList);
        this.createFields(getterMethodList);
    }

    private void sortMethodList(ArrayList<Method> methodList) {
        Collections.sort(methodList, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int index1 = 0;
                int index2 = 0;
                if (o1.isAnnotationPresent(GetProperty.class)) {
                    GetProperty anno1 = o1.getAnnotation(GetProperty.class);
                    GetProperty anno2 = o2.getAnnotation(GetProperty.class);
                    index1 = anno1.index();
                    index2 = anno2.index();
                } else {
                    SetProperty anno1 = o1.getAnnotation(SetProperty.class);
                    SetProperty anno2 = o2.getAnnotation(SetProperty.class);
                    index1 = anno1.index();
                    index2 = anno2.index();
                }
                return index1 - index2;
            }
        });
    }

    private void createFields(ArrayList<Method> getterList) {
        for (Method method : getterList) {
            GetProperty getter = method.getAnnotation(GetProperty.class);
            this.createLabel(getter.value());
            String value = this.getValue(method);
            Text field = this.createTextField(value);
            this.fieldMap.put(getter.value(), field);
        }
    }

    private String getValue(Method method) {
        try {
            return (String)method.invoke((Object)this.query, new Object[0]);
        }
        catch (Exception exception) {
            return "error";
        }
    }

    private Text createTextField(String value) {
        Text text = new Text((Composite)this, 2048);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        text.setText(value);
        return text;
    }

    private Label createLabel(String text) {
        Label lab = new Label((Composite)this, 64);
        lab.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        lab.setBackground(this.background);
        lab.setText(text);
        return lab;
    }

    public AbstractQuery getQuery() throws SetDataException {
        this.setQueryData();
        return this.query;
    }

    private void setQueryData() throws SetDataException {
        assert (this.query != null);
        ArrayList<Method> setterMethodList = new ArrayList<Method>();
        Method[] methodArray = ((Object)((Object)this.query)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(SetProperty.class)) {
                setterMethodList.add(method);
            }
            ++n2;
        }
        this.sortMethodList(setterMethodList);
        this.setData(setterMethodList);
    }

    private void setData(ArrayList<Method> setterList) throws SetDataException {
        for (Method method : setterList) {
            SetProperty setter = method.getAnnotation(SetProperty.class);
            Text field = this.fieldMap.get(setter.value());
            String value = field.getText();
            this.setValue(this.query, method, value);
        }
    }

    private void setValue(AbstractQuery query, Method method, String value) throws SetDataException {
        try {
            method.invoke((Object)query, value);
        }
        catch (Exception e) {
            throw (SetDataException)e.getCause();
        }
    }
}

