/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.messwerte.preferences;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.LabGroup;
import ch.elexis.data.LabItem;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class LabGroupPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private LabGroup actGroup = null;
    private ComboViewer groupsViewer;
    private ListViewer itemsViewer;
    Button newButton;
    Button removeButton;
    Button renameButton;
    Button addItemButton;
    Button removeItemButton;

    public LabGroupPrefs() {
        super("Gruppen");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite topArea = new Composite(composite, 0);
        topArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 20;
        topArea.setLayout((Layout)layout);
        Label label = new Label(topArea, 0);
        label.setText("F\u00fcr Laborverordnungen und Laborbl\u00e4tter k\u00f6nnen hier\nzus\u00e4tzlich zu den normalen Laborgruppen\nweitere Gruppen definiert werden, z. B. \"Diabeteskontrolle\".");
        label.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        label = new Label(topArea, 0);
        label.setText("Gruppe:");
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.groupsViewer = new ComboViewer(topArea, 8);
        gd = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false);
        gd.verticalAlignment = 1;
        this.groupsViewer.getControl().setLayoutData((Object)gd);
        this.groupsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)LabGroupPrefs.this.groupsViewer.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof LabGroup) {
                    LabGroupPrefs.this.actGroup = (LabGroup)element;
                    LabGroupPrefs.this.itemsViewer.refresh();
                }
                LabGroupPrefs.this.updateButtonsState();
            }
        });
        this.groupsViewer.setContentProvider((IContentProvider)new GroupsContentProvider());
        this.groupsViewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.groupsViewer.setInput((Object)this);
        Composite groupButtonArea = new Composite(topArea, 8);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        groupButtonArea.setLayout((Layout)layout);
        this.newButton = new Button(groupButtonArea, 8);
        this.newButton.setText("Neu...");
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Neue Laborgruppe", "Bitte w\u00e4hlen Sie einen Namen f\u00fcr die Gruppe", "", null);
                int rc = dialog.open();
                if (rc == 0) {
                    String name = dialog.getValue();
                    LabGroup group = new LabGroup(name, null);
                    LabGroupPrefs.this.groupsViewer.refresh();
                    LabGroupPrefs.this.groupsViewer.setSelection((ISelection)new StructuredSelection((Object)group));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeButton = new Button(groupButtonArea, 8);
        this.removeButton.setText("L\u00f6schen");
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LabGroupPrefs.this.actGroup != null && SWTHelper.askYesNo((String)"Gruppe L\u00f6schen", (String)("Wollen Sie die Gruppe \"" + LabGroupPrefs.this.actGroup.getLabel() + "\" wirklich l\u00f6schen?"))) {
                    LabGroupPrefs.this.actGroup.removeAll();
                    LabGroupPrefs.this.actGroup.delete();
                    LabGroupPrefs.this.actGroup = null;
                    LabGroupPrefs.this.groupsViewer.refresh();
                    LabGroupPrefs.this.itemsViewer.refresh();
                    LabGroupPrefs.this.selectFirstGroup();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.renameButton = new Button(groupButtonArea, 8);
        this.renameButton.setText("Umbenennen");
        this.renameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                InputDialog dlg;
                if (LabGroupPrefs.this.actGroup != null && (dlg = new InputDialog(LabGroupPrefs.this.getShell(), "Gruppe umbenennen", "Bitte geben Sie den neuen Namen der Gruppe ein.", LabGroupPrefs.this.actGroup.getName(), null)).open() == 0 && !StringTool.isNothing((Object)(name = dlg.getValue()))) {
                    LabGroupPrefs.this.actGroup.setName(name);
                    LabGroupPrefs.this.groupsViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite bottomArea = new Composite(composite, 0);
        bottomArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        bottomArea.setLayout((Layout)new GridLayout(1, false));
        label = new Label(bottomArea, 0);
        label.setText("Enthaltene Laborwerte:");
        this.itemsViewer = new ListViewer(bottomArea, 2818);
        this.itemsViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.itemsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LabGroupPrefs.this.updateItemButtonsState();
            }
        });
        this.itemsViewer.setContentProvider((IContentProvider)new GroupItemsContentProvider());
        this.itemsViewer.setLabelProvider((IBaseLabelProvider)new ItemsLabelProvider());
        this.itemsViewer.setInput((Object)this);
        Composite buttonArea = new Composite(bottomArea, 0);
        buttonArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        buttonArea.setLayout((Layout)new GridLayout(2, true));
        this.addItemButton = new Button(buttonArea, 8);
        this.addItemButton.setText("Hinzuf\u00fcgen...");
        this.addItemButton.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.removeItemButton = new Button(buttonArea, 8);
        this.removeItemButton.setText("Entfernen");
        this.removeItemButton.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.addItemButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ItemsSelectionDialog dialog;
                if (LabGroupPrefs.this.actGroup != null && (dialog = new ItemsSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), LabGroupPrefs.this.actGroup)).open() == 0) {
                    LabGroupPrefs.this.itemsViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeItemButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LabGroupPrefs.this.actGroup != null) {
                    IStructuredSelection sel = (IStructuredSelection)LabGroupPrefs.this.itemsViewer.getSelection();
                    for (Object obj : sel.toList()) {
                        if (!(obj instanceof LabItem)) continue;
                        LabItem item = (LabItem)obj;
                        LabGroupPrefs.this.actGroup.removeItem(item);
                    }
                    LabGroupPrefs.this.itemsViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.selectFirstGroup();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void selectFirstGroup() {
        Object element = this.groupsViewer.getElementAt(0);
        if (element != null) {
            this.groupsViewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private void updateButtonsState() {
        this.updateGroupButtonsState();
        this.updateItemButtonsState();
    }

    private void updateGroupButtonsState() {
        if (this.actGroup != null) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    private void updateItemButtonsState() {
        if (this.actGroup != null) {
            this.addItemButton.setEnabled(true);
            IStructuredSelection sel = (IStructuredSelection)this.itemsViewer.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof LabItem) {
                this.removeItemButton.setEnabled(true);
            } else {
                this.removeItemButton.setEnabled(false);
            }
        } else {
            this.addItemButton.setEnabled(false);
            this.removeItemButton.setEnabled(false);
        }
    }

    class GroupItemsContentProvider
    implements IStructuredContentProvider {
        GroupItemsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (LabGroupPrefs.this.actGroup != null) {
                List items = LabGroupPrefs.this.actGroup.getItems();
                Collections.sort(items);
                return items.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class GroupsContentProvider
    implements IStructuredContentProvider {
        GroupsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Query query = new Query(LabGroup.class);
            query.orderBy(false, new String[]{"Name"});
            ArrayList groups = query.execute();
            if (groups == null) {
                groups = new ArrayList();
            }
            return groups.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class ItemsLabelProvider
    extends DefaultLabelProvider {
        ItemsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof LabItem) {
                LabItem item = (LabItem)element;
                StringBuffer sb = new StringBuffer();
                sb.append(item.getGroup());
                sb.append(" - ");
                sb.append(item.get("titel"));
                return sb.toString();
            }
            return element.toString();
        }
    }

    class ItemsSelectionDialog
    extends TitleAreaDialog {
        private LabGroup group;
        private ListViewer viewer;

        ItemsSelectionDialog(Shell parentShell, LabGroup group) {
            super(parentShell);
            this.group = group;
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            this.setMessage("Bitte w\u00e4hlen Sie die Laborwerte aus.");
            this.setTitle("Laborwerte w\u00e4hlen");
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label(composite, 0);
            label.setText("Gruppe: " + this.group.getName());
            this.viewer = new ListViewer(composite, 2818);
            this.viewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.viewer.setContentProvider((IContentProvider)new ItemsContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ItemsLabelProvider());
            this.viewer.setInput((Object)this);
            return composite;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
                List existingItems = this.group.getItems();
                ArrayList<LabItem> items = new ArrayList<LabItem>();
                for (Object obj : sel.toList()) {
                    LabItem item;
                    if (!(obj instanceof LabItem) || existingItems.contains(item = (LabItem)obj)) continue;
                    items.add(item);
                }
                this.group.addItems(items);
            }
            this.setReturnCode(buttonId);
            this.close();
        }

        class ItemsContentProvider
        implements IStructuredContentProvider {
            ItemsContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                Query query = new Query(LabItem.class);
                query.orderBy(false, new String[]{"Gruppe", "prio", "titel"});
                ArrayList items = query.execute();
                if (items == null) {
                    items = new ArrayList();
                }
                List contained = ItemsSelectionDialog.this.group.getItems();
                items.removeAll(contained);
                return items.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

