/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.iatrix.bestellung.rose.XsdResolver;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class XmlValidator {
    public void validateXml(String xml) throws IllegalStateException {
        try {
            this.setXmlLimits();
            Bundle bundle = Platform.getBundle((String)"org.iatrix.bestellung.rose");
            if (bundle == null) {
                throw new IllegalStateException("Bundle not found: org.iatrix.bestellung.rose");
            }
            URL xsdUrl = bundle.getEntry("rsc/gs1/ecom/Order.xsd");
            if (xsdUrl == null) {
                throw new IllegalStateException("XSD file not found: rsc/gs1/ecom/Order.xsd");
            }
            URL resolvedUrl = FileLocator.resolve((URL)xsdUrl);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(new XsdResolver());
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream xsdStream = resolvedUrl.openStream();){
                Schema schema = factory.newSchema(new StreamSource(xsdStream));
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(new StringReader(xml)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException("XML validation failed: " + e.getMessage());
        }
    }

    private void setXmlLimits() {
        System.setProperty("jdk.xml.maxOccurLimit", "10000");
        System.setProperty("jdk.xml.entityExpansionLimit", "10000");
        System.setProperty("jdk.xml.elementAttributeLimit", "10000");
        System.setProperty("jdk.xml.totalEntitySizeLimit", "10000000");
        System.setProperty("jdk.xml.maxElementDepth", "10000");
    }
}

