/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose.service;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.exchange.XChangeException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOrderTransportService {
    private static Logger logger = LoggerFactory.getLogger(HttpOrderTransportService.class);
    private boolean isTestMode = false;

    public void setTestMode(boolean isTestMode) {
        this.isTestMode = isTestMode;
    }

    public String retrieveAccessToken(String clientId, String clientSecret) throws XChangeException {
        try {
            String line;
            URL url = this.getUrl("https://api.clustertec.com/auth/realms/GHP/protocol/openid-connect/token", "https://test.api.clustertec.com/auth/realms/GHP/protocol/openid-connect/token");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Basic " + this.encodeBasicAuth(clientId, clientSecret));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoOutput(true);
            String body = "grant_type=client_credentials";
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStream os = conn.getOutputStream();){
                os.write(body.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
            return json.get("access_token").getAsString();
        }
        catch (Exception e) {
            throw new XChangeException("Error retrieving the token: " + e.getMessage());
        }
    }

    public void sendOrderRequest(String xml, String token, List<IOrderEntry> entriesToMark) throws XChangeException {
        try {
            String line;
            URL url = this.getUrl("https://api.clustertec.com/services/orders", "https://test.api.clustertec.com/services/orders");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", "Bearer " + token);
            conn.setRequestProperty("Content-Type", "application/vnd.orders.v1+xml");
            conn.setDoOutput(true);
            Throwable throwable = null;
            Object var7_10 = null;
            try (OutputStream os = conn.getOutputStream();){
                os.write(xml.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            int responseCode = conn.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream(), StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            if (responseCode == 409) {
                this.showUserFriendlyDialog(Messages.HttpOrderTransportService_OrderAlreadySent_Title, Messages.HttpOrderTransportService_OrderAlreadySent_Message);
                return;
            }
            if (responseCode != 200) {
                throw new XChangeException("Error sending the order: HTTP " + responseCode + " - " + response.toString());
            }
            for (IOrderEntry entry : entriesToMark) {
                entry.setState(OrderEntryState.ORDERED);
                CoreModelServiceHolder.get().save((Identifiable)entry);
            }
            String landingPage = this.extractLandingPageUrl(response.toString());
            if (landingPage != null && !landingPage.isEmpty() && !this.isTestMode) {
                if (this.showConfirmationDialog()) {
                    this.openBrowser(landingPage);
                } else {
                    logger.info("User has not opened the landing Page");
                }
            }
        }
        catch (Exception e) {
            throw new XChangeException("Error sending the order: " + e.getMessage());
        }
    }

    private URL getUrl(String liveUrl, String testUrl) throws URISyntaxException, MalformedURLException {
        return new URI(this.isTestMode ? testUrl : liveUrl).toURL();
    }

    private String extractLandingPageUrl(String responseXml) {
        String startTag = "<landingPageUrl>";
        String endTag = "</landingPageUrl>";
        int startIdx = responseXml.indexOf(startTag);
        if (startIdx == -1) {
            return null;
        }
        int endIdx = responseXml.indexOf(endTag, startIdx);
        if (endIdx == -1) {
            return null;
        }
        int contentStart = startIdx + startTag.length();
        return responseXml.substring(contentStart, endIdx).trim();
    }

    private void openBrowser(String url) {
        Program.launch((String)url);
    }

    private String encodeBasicAuth(String clientId, String clientSecret) {
        String credentials = clientId + ":" + clientSecret;
        return Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
    }

    private boolean showConfirmationDialog() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        MessageBox messageBox = new MessageBox(shell, 194);
        messageBox.setText(Messages.Attention);
        messageBox.setMessage(Messages.HttpOrderTransportService_Dialog);
        int response = messageBox.open();
        return response == 64;
    }

    private void showUserFriendlyDialog(String title, String message) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 67680);
        shell.setText(title);
        shell.setSize(480, 240);
        shell.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label((Composite)shell, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        new Label((Composite)shell, 0).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Link link = new Link((Composite)shell, 64);
        link.setText(Messages.HttpOrderTransportService_LinkText);
        link.setToolTipText(Messages.HttpOrderTransportService_LinkTooltip);
        link.setLayoutData((Object)new GridData(4, 128, true, false));
        link.addListener(13, e -> Program.launch((String)"https://ghp.clustertec.com/auth/realms/GHP/protocol/openid-connect/auth?client_id=marketplace-portal&redirect_uri=https%3A%2F%2Fghp.clustertec.com%2F%3Ferror%3Dinvalid_request%26error_description%3DMissing%2Bparameter%253A%2Bresponse_type%26state%3D551f02b0-3793-4ed7-8b29-9717fba87de2&state=7769aa6d-1871-4555-8b33-70a805f696f6&response_mode=fragment&response_type=code&scope=openid&nonce=f472a669-678a-4b0d-8a80-8b8f22750e91"));
        Button okButton = new Button((Composite)shell, 8);
        okButton.setText(Messages.Core_Ok);
        GridData gd = new GridData(0x1000008, 1024, true, true);
        int widthHint = this.convertHorizontalDLUsToPixels(okButton, 61);
        gd.widthHint = Math.max(90, widthHint);
        okButton.setLayoutData((Object)gd);
        okButton.addListener(13, e -> shell.close());
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private int convertHorizontalDLUsToPixels(Button button, int dlus) {
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        int avgCharWidth = (int)gc.getFontMetrics().getAverageCharacterWidth();
        gc.dispose();
        return dlus * avgCharWidth / 4;
    }
}

