/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.iatrix.bestellung.rose.InputSourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XsdResolver
implements LSResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(XsdResolver.class);
    private static final Map<String, String> XSD_RESOURCE_MAP = new HashMap<String, String>();

    static {
        XSD_RESOURCE_MAP.put("eComCommon.xsd", "/rsc/gs1/ecom/eComCommon.xsd");
        XSD_RESOURCE_MAP.put("SharedCommon.xsd", "/rsc/gs1/shared/SharedCommon.xsd");
        XSD_RESOURCE_MAP.put("StandardBusinessDocumentHeader.xsd", "/rsc/sbdh/StandardBusinessDocumentHeader.xsd");
        XSD_RESOURCE_MAP.put("DocumentIdentification.xsd", "/rsc/sbdh/DocumentIdentification.xsd");
        XSD_RESOURCE_MAP.put("Partner.xsd", "/rsc/sbdh/Partner.xsd");
        XSD_RESOURCE_MAP.put("Manifest.xsd", "/rsc/sbdh/Manifest.xsd");
        XSD_RESOURCE_MAP.put("BusinessScope.xsd", "/rsc/sbdh/BusinessScope.xsd");
        XSD_RESOURCE_MAP.put("BasicTypes.xsd", "/rsc/sbdh/BasicTypes.xsd");
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream stream;
        block5: {
            String resourcePath;
            block4: {
                try {
                    resourcePath = XSD_RESOURCE_MAP.get(systemId.substring(systemId.lastIndexOf(47) + 1));
                    if (resourcePath != null) break block4;
                    logger.error("Could not find XSD: {}", (Object)systemId);
                    return null;
                }
                catch (Exception e) {
                    logger.error("Error when resolving the resource: {}", (Object)systemId, (Object)e);
                    return null;
                }
            }
            stream = this.getClass().getResourceAsStream(resourcePath);
            if (stream != null) break block5;
            logger.error("Could not load XSD resource: {}", (Object)resourcePath);
            return null;
        }
        return new InputSourceImpl(publicId, systemId, stream);
    }
}

