/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Bestellung;
import ch.elexis.data.PersistentObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.iatrix.bestellung.rose.service.Gs1OrderXmlGenerator;
import org.iatrix.bestellung.rose.service.HttpOrderTransportService;
import org.iatrix.bestellung.rose.service.XmlValidator;
import org.slf4j.LoggerFactory;

public class Sender
implements IDataSender {
    private final Gs1OrderXmlGenerator xmlGenerator;
    private final XmlValidator xmlValidator;
    private final HttpOrderTransportService transportService;
    public static final String DEBUG_MODE = "rose.order.debug";
    private final List<String> orderRequests = new ArrayList<String>();

    public Sender() {
        this.xmlGenerator = new Gs1OrderXmlGenerator();
        this.xmlValidator = new XmlValidator();
        this.transportService = new HttpOrderTransportService();
    }

    public Sender(boolean isTestMode) {
        this();
        this.transportService.setTestMode(isTestMode);
    }

    public XChangeElement store(Object output) throws XChangeException {
        if (output instanceof IOrder) {
            IOrder order = (IOrder)output;
            String xml = this.xmlGenerator.createOrderXml(order);
            this.xmlValidator.validateXml(xml);
            if (System.getProperty(DEBUG_MODE) != null) {
                System.out.println("GS1 Rose Order XML Payload:\n" + xml);
            }
            this.orderRequests.add(xml);
            return null;
        }
        throw new XChangeException("Can't handle object of class " + output.getClass().getName());
    }

    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return clazz.equals(Bestellung.class);
    }

    public void finalizeExport() throws XChangeException {
        String clientId = this.getClientId();
        String secretId = this.getClientSecret();
        String token = this.transportService.retrieveAccessToken(clientId, secretId);
        for (String orderRequest : this.orderRequests) {
            this.transportService.sendOrderRequest(orderRequest, token, this.xmlGenerator.getExportedEntries());
        }
        this.orderRequests.clear();
    }

    private String getClientId() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    String secret = idProps.getProperty("client_id_prod");
                    if (StringUtils.isNotEmpty((CharSequence)secret)) {
                        return secret;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return ConfigServiceHolder.getGlobal((String)"org.iatrix.bestellung.rose/client_id_prod", (String)"");
    }

    private String getClientSecret() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    String secret = idProps.getProperty("client_secret_prod");
                    if (StringUtils.isNotEmpty((CharSequence)secret)) {
                        return secret;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return ConfigServiceHolder.getGlobal((String)"org.iatrix.bestellung.rose/client_secret_prod", (String)"");
    }

    /*
     * WARNING - void declaration
     */
    public boolean canHandle(Identifiable identifiable) {
        String[] supplierIds;
        if (!(identifiable instanceof IOrder)) {
            return false;
        }
        IOrder iOrder = (IOrder)identifiable;
        String cfg = ConfigServiceHolder.getGlobal((String)"org.iatrix.bestellung.rose/supplier", (String)"");
        if (StringUtils.isBlank((CharSequence)cfg)) {
            return false;
        }
        String[] stringArray = supplierIds = StringUtils.split((String)cfg, (char)',');
        int n = supplierIds.length;
        int n2 = 0;
        while (n2 < n) {
            void order;
            String supplierId = stringArray[n2];
            IContact supplier = CoreModelServiceHolder.get().load(supplierId, IContact.class).orElse(null);
            if (supplier != null && OrderServiceHolder.get().containsSupplier((IOrder)order, supplier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

