/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier.ses;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Mandant;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalCookieService {
    private static Logger log = LoggerFactory.getLogger(PortalCookieService.class);
    private String httpsUrl;
    HttpsURLConnection con = null;
    DataInputStream input;
    private String userid;
    private String password;
    private ViollierConnectorSettings mySettings;

    public String getCookie() throws ClientProtocolException, IOException, ElexisException {
        this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        this.httpsUrl = this.mySettings.getGlobalLoginUrl();
        if (!this.mySettings.getMandantUseGlobalSettings().booleanValue()) {
            this.userid = this.mySettings.getMandantUserName();
            this.password = this.mySettings.getMandantUserPassword();
        } else {
            this.userid = this.mySettings.getGlobalUserName();
            this.password = this.mySettings.getGlobalUserPassword();
        }
        if (this.userid.isEmpty() || this.password.isEmpty()) {
            log.error("UserId[" + this.userid + "]\t Password[" + this.password + "]");
            throw new ElexisException(PortalCookieService.class, Messages.Exception_errorMessageNoUserPasswordDefined, 6);
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.httpsUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
        nameValuePairs.add(new BasicNameValuePair("userid", this.userid));
        nameValuePairs.add(new BasicNameValuePair("password", this.password));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        String cookie = "";
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (!response.getStatusLine().toString().equalsIgnoreCase("HTTP/1.1 302 Found")) {
            throw new ElexisException(PortalCookieService.class, Messages.Handler_errorMessageGetCookie, 3);
        }
        Header[] headers = response.getHeaders("Set-Cookie");
        String headerValue1 = headers[1].getValue().replaceAll("SCDID_S=", "");
        headerValue1 = headerValue1.replaceAll("; path=/; Secure; (HttpOnly)?", "");
        cookie = URLEncoder.encode(headerValue1, "UTF-8");
        return cookie;
    }
}

