/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.viollier;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Mandant;
import java.net.InetAddress;
import java.text.MessageFormat;
import net.medshare.connector.viollier.Messages;
import net.medshare.connector.viollier.data.ViollierConnectorSettings;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ViollierConnectorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ViollierConnectorSettings mySettings;
    private GridData gridDataForLabels;
    private GridData gridDataForInputs;
    private Group gGlobalSettings;
    private Text tGlobalLoginUrl;
    private Text tGlobalConsultItUrl;
    private Text tGlobalOrderItUrl;
    private Text tGlobalUserName;
    private Text tGlobalUserPassword;
    private Text tGlobalViollierClientId;
    private Button bGlobalPreferedPresentation;
    private Group gMandantSettings;
    private Button bMandantUseGlobalSettings;
    private Text tMandantUserName;
    private Text tMandantUserPassword;
    private Text tMandantViollierClientId;
    private Group gMachineSettings;
    private Button bMachineUseGlobalSettings;
    private Button bMachinePreferedPresentation;
    private Boolean isInitializing = true;

    public ViollierConnectorPreferencePage() {
        super(1);
    }

    public boolean performOk() {
        this.mySettings.setGlobalLoginUrl(this.tGlobalLoginUrl.getText());
        this.mySettings.setGlobalConsultItUrl(this.tGlobalConsultItUrl.getText());
        this.mySettings.setGlobalOrderItUrl(this.tGlobalOrderItUrl.getText());
        this.mySettings.setGlobalUserName(this.tGlobalUserName.getText());
        this.mySettings.setGlobalUserPassword(this.tGlobalUserPassword.getText());
        this.mySettings.setGlobalViollierClientId(this.tGlobalViollierClientId.getText());
        this.mySettings.setGlobalPreferedPresentation(this.bGlobalPreferedPresentation.getSelection());
        this.mySettings.setMandantUsingGlobalSettings(this.bMandantUseGlobalSettings.getSelection());
        this.mySettings.setMandantUserName(this.tMandantUserName.getText());
        this.mySettings.setMandantUserPassword(this.tMandantUserPassword.getText());
        this.mySettings.setMandantViollierClientId(this.tMandantViollierClientId.getText());
        this.mySettings.setMachineUsingGlobalSettings(this.bMachineUseGlobalSettings.getSelection());
        this.mySettings.setMachinePreferedPresentation(this.bMachinePreferedPresentation.getSelection());
        this.mySettings.saveSettings();
        return true;
    }

    public void init(IWorkbench workbench) {
        if (this.mySettings == null) {
            this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        }
    }

    protected Control createContents(Composite parent) {
        String undefined = Messages.Preferences_undefiniert;
        Text dummy = new Text(parent, 0);
        dummy.setText(Messages.Preferences_LoginUrl);
        dummy.pack();
        this.gridDataForLabels = new GridData(dummy.getSize().x, dummy.getLineHeight());
        this.gridDataForInputs = new GridData(768);
        if (this.mySettings == null) {
            this.mySettings = new ViollierConnectorSettings((Mandant)ElexisEventDispatcher.getSelected(Mandant.class));
        }
        dummy.dispose();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        Group grp = this.gGlobalSettings = new Group(comp, 0);
        grp.setText(Messages.Preferences_GlobalSettings);
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        Label lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_LoginUrl);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalLoginUrl = new Text((Composite)grp, 2052);
        this.tGlobalLoginUrl.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalLoginUrl.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_ConsultItUrl);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalConsultItUrl = new Text((Composite)grp, 2052);
        this.tGlobalConsultItUrl.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalConsultItUrl.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_OrderItUrl);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalOrderItUrl = new Text((Composite)grp, 2052);
        this.tGlobalOrderItUrl.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalOrderItUrl.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UserName);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalUserName = new Text((Composite)grp, 2052);
        this.tGlobalUserName.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalUserName.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UserPassword);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalUserPassword = new Text((Composite)grp, 2052);
        this.tGlobalUserPassword.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalUserPassword.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_ViollierClientId);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tGlobalViollierClientId = new Text((Composite)grp, 2052);
        this.tGlobalViollierClientId.setLayoutData((Object)this.gridDataForInputs);
        this.tGlobalViollierClientId.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_PreferedPresentation);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bGlobalPreferedPresentation = new Button((Composite)grp, 32);
        this.bGlobalPreferedPresentation.setSelection(false);
        String mandantname = "";
        try {
            mandantname = this.mySettings.getMandant().getLabel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        grp = this.gMandantSettings = new Group(comp, 0);
        grp.setText(MessageFormat.format(Messages.Preferences_MandantSettingsFor, mandantname));
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_GlobalSettings);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bMandantUseGlobalSettings = new Button((Composite)grp, 32);
        this.bMandantUseGlobalSettings.setSelection(false);
        this.bMandantUseGlobalSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ViollierConnectorPreferencePage.this.isInitializing.booleanValue()) {
                    return;
                }
                Button c = (Button)e.widget;
                Boolean mandantUseGlobalSettings = c.getSelection();
                ViollierConnectorPreferencePage.this.mySettings.setMandantUsingGlobalSettings(mandantUseGlobalSettings);
                ViollierConnectorPreferencePage.this.showMandantSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UserName);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMandantUserName = new Text((Composite)grp, 2052);
        this.tMandantUserName.setLayoutData((Object)this.gridDataForInputs);
        this.tMandantUserName.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_UserPassword);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMandantUserPassword = new Text((Composite)grp, 2052);
        this.tMandantUserPassword.setLayoutData((Object)this.gridDataForInputs);
        this.tMandantUserPassword.setText(undefined);
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_ViollierClientId);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.tMandantViollierClientId = new Text((Composite)grp, 2052);
        this.tMandantViollierClientId.setLayoutData((Object)this.gridDataForInputs);
        this.tMandantViollierClientId.setText(undefined);
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        grp = this.gMachineSettings = new Group(comp, 0);
        grp.setText(MessageFormat.format(Messages.Preferences_LocalSettingsFor, hostname));
        grp.setLayout((Layout)new GridLayout(2, false));
        grp.setLayoutData((Object)new GridData(768));
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_GlobalSettings);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bMachineUseGlobalSettings = new Button((Composite)grp, 32);
        this.bMachineUseGlobalSettings.setSelection(false);
        this.bMachineUseGlobalSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ViollierConnectorPreferencePage.this.isInitializing.booleanValue()) {
                    return;
                }
                Button c = (Button)e.widget;
                Boolean machineUseGlobalSettings = c.getSelection();
                ViollierConnectorPreferencePage.this.mySettings.setMachineUsingGlobalSettings(machineUseGlobalSettings);
                ViollierConnectorPreferencePage.this.showMachineSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lbl = new Label((Composite)grp, 0);
        lbl.setText(Messages.Preferences_PreferedPresentation);
        lbl.setLayoutData((Object)this.gridDataForLabels);
        this.bMachinePreferedPresentation = new Button((Composite)grp, 32);
        this.bMachinePreferedPresentation.setSelection(false);
        this.bMachinePreferedPresentation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ViollierConnectorPreferencePage.this.isInitializing.booleanValue()) {
                    return;
                }
                Button c = (Button)e.widget;
                Boolean machinePreferedPresentation = c.getSelection();
                ViollierConnectorPreferencePage.this.mySettings.setMachinePreferedPresentation(machinePreferedPresentation);
                ViollierConnectorPreferencePage.this.showMachineSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showSettings();
        this.isInitializing = false;
        return comp;
    }

    private void showSettings() {
        this.tGlobalLoginUrl.setText(this.mySettings.getGlobalLoginUrl());
        this.tGlobalConsultItUrl.setText(this.mySettings.getGlobalConsultItUrl());
        this.tGlobalOrderItUrl.setText(this.mySettings.getGlobalOrderItUrl());
        this.tGlobalUserName.setText(this.mySettings.getGlobalUserName());
        this.tGlobalUserPassword.setText(this.mySettings.getGlobalUserPassword());
        this.tGlobalViollierClientId.setText(this.mySettings.getGlobalViollierClientId());
        this.bGlobalPreferedPresentation.setSelection(this.mySettings.getGlobalPreferedPresentation().booleanValue());
        this.showMandantSettings();
        this.showMachineSettings();
    }

    private void showMandantSettings() {
        Boolean mandantUseGlobalSettings = this.mySettings.isMandantUsingGlobalSettings();
        String mandantname = "";
        try {
            mandantname = this.mySettings.getMandant().getLabel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gMandantSettings.setText(MessageFormat.format(Messages.Preferences_MandantSettingsFor, mandantname));
        this.bMandantUseGlobalSettings.setSelection(mandantUseGlobalSettings.booleanValue());
        this.tMandantUserName.setEditable(mandantUseGlobalSettings == false);
        this.tMandantUserPassword.setEditable(mandantUseGlobalSettings == false);
        this.tMandantViollierClientId.setEditable(mandantUseGlobalSettings == false);
        this.tMandantUserName.setText(this.mySettings.getMandantUserName());
        this.tMandantUserPassword.setText(this.mySettings.getMandantUserPassword());
        this.tMandantViollierClientId.setText(this.mySettings.getMandantViollierClientId());
    }

    private void showMachineSettings() {
        Boolean machineUseGlobalSettings = this.mySettings.isMachineUsingGlobalSettings();
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gMachineSettings.setText(MessageFormat.format(Messages.Preferences_LocalSettingsFor, hostname));
        this.bMachineUseGlobalSettings.setSelection(machineUseGlobalSettings.booleanValue());
        this.bMachinePreferedPresentation.setSelection(this.mySettings.getMachinePreferedPresentation().booleanValue());
    }

    protected void createFieldEditors() {
    }
}

