/*
 * Decompiled with CFR 0.152.
 */
package net.medshare.connector.aerztekasse.invoice;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.medshare.connector.aerztekasse.Messages;
import net.medshare.connector.aerztekasse.data.AerztekasseSettings;
import net.medshare.connector.aerztekasse.invoice.ClientHttpRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.LoggerFactory;

public class InvoiceOutputter
extends XMLExporter {
    public AerztekasseSettings settings;
    public boolean transferState = false;
    private Text text;
    private String responseState;
    private String responseError;
    private String outputDir;
    private String transmittedInvoices;
    private String failedInvoices;
    private int transmittedInvoicesCount = 0;
    private int failedInvoicesCount = 0;

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        SWTHelper.SimpleDialog dlg;
        final Result ret = new Result();
        this.transmittedInvoices = "";
        this.failedInvoices = "";
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        if (this.outputDir == null && (dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

            public Control getControl(Composite parent) {
                return InvoiceOutputter.this.createSettingsControl(parent);
            }

            public void beforeClosing() {
            }
        })).open() != 0) {
            return ret;
        }
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    boolean abort = false;
                    monitor.beginTask(Messages.InvoiceOutputter_DoExport, rnn.size() * 3);
                    File f = new File(InvoiceOutputter.this.outputDir);
                    f.mkdirs();
                    ArrayList<Object> fileNamesXml = new ArrayList<Object>(rnn.size());
                    for (Rechnung rn : rnn) {
                        Object fileNameXml = rn.getNr();
                        Iterator filePathXml = InvoiceOutputter.this.outputDir + (String)fileNameXml + ".xml";
                        fileNameXml = type == IRnOutputter.TYPE.STORNO ? (String)fileNameXml + "_storno.xml" : (String)fileNameXml + ".xml";
                        fileNamesXml.add(fileNameXml);
                        if (InvoiceOutputter.this.doExport(rn, (String)((Object)filePathXml), type, false) == null) {
                            ret.add(Result.SEVERITY.ERROR, 1, Messages.InvoiceOutputter_ErrorInInvoice + rn.getNr(), (Object)rn, true);
                            abort = true;
                            break;
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    String filePathZip = InvoiceOutputter.this.outputDir + "invoices.zip";
                    if (!abort) {
                        try {
                            InvoiceOutputter.deleteFile(filePathZip);
                            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(filePathZip));
                            for (Object fileNameXml : fileNamesXml) {
                                int len;
                                String filePathXml = InvoiceOutputter.this.outputDir + (String)fileNameXml;
                                byte[] buf = new byte[1024];
                                FileInputStream in = new FileInputStream(filePathXml);
                                out.putNextEntry(new ZipEntry((String)fileNameXml));
                                while ((len = in.read(buf)) > 0) {
                                    out.write(buf, 0, len);
                                }
                                out.closeEntry();
                                in.close();
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            out.finish();
                            out.flush();
                            out.close();
                        }
                        catch (IOException e) {
                            ExHandler.handle((Throwable)e);
                            abort = true;
                        }
                    }
                    String filePathAnswer = InvoiceOutputter.this.outputDir + "answer.html";
                    if (!abort) {
                        InvoiceOutputter.deleteFile(filePathAnswer);
                        if (InvoiceOutputter.this.doHttpPost(filePathZip, filePathAnswer)) {
                            if (InvoiceOutputter.this.transferState) {
                                for (Rechnung rn : rnn) {
                                    if (type == IRnOutputter.TYPE.ORIG) {
                                        rn.setStatus(InvoiceState.PAID);
                                    }
                                    ++InvoiceOutputter.this.transmittedInvoicesCount;
                                    InvoiceOutputter.this.transmittedInvoices = String.valueOf(InvoiceOutputter.this.transmittedInvoices) + Messages.InvoiceOutputter_SuccessInvoiceNr + rn.getNr() + " : " + Messages.InvoiceOutputter_NewState + " : " + rn.getInvoiceState().getLocaleText();
                                    monitor.worked(1);
                                    if (!monitor.isCanceled()) {
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                for (Rechnung rn : rnn) {
                                    rn.reject(InvoiceState.REJECTCODE.REJECTED_BY_PEER, Messages.InvoiceOutputter_TransmissionFailed + " " + InvoiceOutputter.this.responseState + "/" + InvoiceOutputter.this.responseError);
                                    ++InvoiceOutputter.this.failedInvoicesCount;
                                    InvoiceOutputter.this.failedInvoices = String.valueOf(InvoiceOutputter.this.failedInvoices) + Messages.InvoiceOutputter_FailureInvoiceNr + rn.getNr() + " :  " + InvoiceOutputter.this.responseState + "/" + InvoiceOutputter.this.responseError;
                                    monitor.worked(1);
                                    if (!monitor.isCanceled()) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else {
                            Iterator ir = rnn.iterator();
                            Rechnung r = (Rechnung)ir.next();
                            ret.add(Result.SEVERITY.ERROR, 1, Messages.InvoiceOutputter_ErrorHttpPost, (Object)r, true);
                            r.setStatus(InvoiceState.DEFECTIVE);
                        }
                    }
                    for (Object fileNameXml : fileNamesXml) {
                        InvoiceOutputter.this.deleteFileOnExit(InvoiceOutputter.this.outputDir + (String)fileNameXml);
                    }
                    InvoiceOutputter.this.deleteFileOnExit(filePathZip);
                    InvoiceOutputter.this.deleteFileOnExit(filePathAnswer);
                    monitor.done();
                }
            }, null);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            ret.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
        }
        if (!ret.isOK()) {
            Object errorStr = "";
            for (Result.msg errorMsg : ret.getMessages()) {
                errorStr = (String)errorStr + errorMsg.getText() + "\n";
            }
            SWTHelper.alert((String)(Messages.InvoiceOutputter_ErrorInvoice + ((Rechnung)ret.get()).getNr()), (String)errorStr);
        }
        if (this.failedInvoicesCount > 0) {
            if (this.transmittedInvoicesCount + this.failedInvoicesCount < 10) {
                SWTHelper.showError((String)Messages.InvoiceOutputter_TransmittedInvoicesTitle, (String)(Messages.InvoiceOutputter_TransmittedInvoices + this.transmittedInvoices + this.failedInvoices));
            } else {
                SWTHelper.showError((String)Messages.InvoiceOutputter_TransmittedInvoicesTitle, (String)MessageFormat.format(Messages.InvoiceOutputter_TransmisionAKFailure, this.failedInvoicesCount, this.transmittedInvoicesCount));
            }
        } else if (this.transmittedInvoicesCount < 10) {
            SWTHelper.showInfo((String)Messages.InvoiceOutputter_TransmittedInvoicesTitle, (String)(Messages.InvoiceOutputter_TransmittedInvoices + this.transmittedInvoices));
        } else {
            SWTHelper.showInfo((String)Messages.InvoiceOutputter_TransmittedInvoicesTitle, (String)MessageFormat.format(Messages.InvoiceOutputter_TransmisionAKSuccess, this.transmittedInvoicesCount));
        }
        return ret;
    }

    public String getDescription() {
        return Messages.InvoiceOutputter_TransmisionAK;
    }

    public Control createSettingsControl(Object parent) {
        final Composite compParent = (Composite)parent;
        this.outputDir = System.getProperty("java.io.tmpdir") + "InvoiceOutput" + File.separator;
        Composite ret = new Composite(compParent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(ret, 0);
        l.setText(Messages.InvoiceOutputter_InvoiceOutputDir);
        l.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        Button b = new Button(ret, 8);
        GridData buttonData = new GridData();
        buttonData.widthHint = 75;
        b.setLayoutData((Object)buttonData);
        b.setText(Messages.InvoiceOutputter_ChangeDir);
        final Text text = new Text(ret, 2056);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(compParent.getShell(), 4096);
                dd.setFilterPath(InvoiceOutputter.this.outputDir);
                String tmpOutputDir = dd.open();
                if (tmpOutputDir != null) {
                    InvoiceOutputter.this.outputDir = tmpOutputDir.replace("\\", "/") + "/";
                    text.setText(InvoiceOutputter.this.outputDir);
                }
            }
        });
        b.setText(Messages.InvoiceOutputter_ChangeDir);
        text.setText(this.outputDir);
        return ret;
    }

    public boolean doHttpPost(String inFilePath, String outFilepath) {
        boolean returnValue = false;
        try {
            String line;
            this.transferState = false;
            this.responseState = "";
            this.responseError = "";
            if (this.settings == null) {
                this.settings = new AerztekasseSettings(CoreHub.actMandant);
            }
            ClientHttpRequest post = new ClientHttpRequest(this.settings.getUrl());
            post.setParameter("user", this.settings.getUsername());
            post.setParameter("pwd", this.settings.getPassword());
            post.setParameter("chkDoubleOK", "false");
            post.setParameter("docs", "false");
            post.setParameter("lang", "A");
            post.setParameter("txtDocument", new File(inFilePath));
            post.setParameter("btnTransfert", "true");
            FileOutputStream fout = new FileOutputStream(outFilepath);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            BufferedReader input = new BufferedReader(new InputStreamReader(post.post(), "UTF-8"));
            while ((line = input.readLine()) != null) {
                writer.append(line);
                writer.append(System.getProperty("line.separator"));
                writer.flush();
                this.parseHttpPostResponse(line);
            }
            writer.close();
            fout.flush();
            fout.close();
            returnValue = true;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(InvoiceOutputter.class).error("invoice output failure", (Throwable)e);
        }
        return returnValue;
    }

    private void parseHttpPostResponse(String line) {
        int startIndex = line.indexOf("ctl02__TextStatus");
        if (startIndex > 0) {
            this.responseState = this.getResponse(line, startIndex);
            this.transferState = this.responseState.contains("ReadyToControl");
        }
        if ((startIndex = line.indexOf("ctl02__TextError")) > 0) {
            this.responseError = this.getResponse(line, startIndex);
        }
    }

    private String getResponse(String line, int startIndex) {
        int stopIndex;
        if ((startIndex = line.indexOf(">", startIndex)) > 0 && (stopIndex = line.indexOf("<", startIndex)) > startIndex + 2) {
            return line.substring(startIndex + 3, stopIndex);
        }
        return null;
    }

    public static boolean deleteFile(String filename) {
        File f = new File(filename);
        boolean deleted = f.delete();
        return deleted;
    }

    private void deleteFileOnExit(String filename) {
        File f = new File(filename);
        f.deleteOnExit();
    }

    public void customizeDialog(Object rnOutputDialog) {
        if (rnOutputDialog instanceof RnOutputDialog) {
            ((RnOutputDialog)rnOutputDialog).setOkButtonText(Messages.Core_DoSend);
        }
    }
}

