/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.pluginstatistiken.config;

import ch.elexis.core.ui.util.Log;
import com.hilotec.elexis.pluginstatistiken.Datensatz;
import com.hilotec.elexis.pluginstatistiken.PluginstatistikException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KonfigurationWhere {
    private Element element;
    public static final String ELEM_OR = "or";
    public static final String ELEM_AND = "and";
    public static final String ELEM_NOT = "not";
    public static final String ELEM_EQUAL = "equal";
    public static final String ELEM_GREATERTHAN = "greaterthan";
    public static final String ELEM_LESSTHAN = "lessthan";
    public static final String ATTR_A = "a";
    public static final String ATTR_B = "b";
    public static final String REGEX_PLUGINREF = "^\\[.*\\]$";

    public KonfigurationWhere(Element e) {
        this.element = e;
    }

    private ElementTyp getTyp(Element e) {
        String n = e.getTagName();
        if (n.equals(ELEM_AND)) {
            return ElementTyp.E_AND;
        }
        if (n.equals(ELEM_OR)) {
            return ElementTyp.E_OR;
        }
        if (n.equals(ELEM_NOT)) {
            return ElementTyp.E_NOT;
        }
        if (n.equals(ELEM_EQUAL)) {
            return ElementTyp.E_EQUAL;
        }
        if (n.equals(ELEM_GREATERTHAN)) {
            return ElementTyp.E_GREATERTHAN;
        }
        if (n.equals(ELEM_LESSTHAN)) {
            return ElementTyp.E_LESSTHAN;
        }
        return ElementTyp.E_INVALID;
    }

    private List<Element> getChildElements(Element parent) {
        ArrayList<Element> l = new ArrayList<Element>();
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                l.add((Element)n);
            }
            ++i;
        }
        return l;
    }

    private String attrValue(Element e, String name, Datensatz ds) throws PluginstatistikException {
        String val = e.getAttribute(name);
        if (val.matches(REGEX_PLUGINREF)) {
            String feld = ds.getFeld(val.substring(1, val.length() - 1));
            if (feld == null) {
                throw new PluginstatistikException("Ungueltige Referenz: ''");
            }
            val = feld;
        }
        return val;
    }

    private boolean isNum(String val) {
        try {
            Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean matchesElement(Element e, Datensatz ds) throws PluginstatistikException {
        ElementTyp typ = this.getTyp(e);
        switch (typ) {
            case E_AND: {
                List<Element> children = this.getChildElements(e);
                int i = 0;
                while (i < children.size()) {
                    if (!this.matchesElement(children.get(i), ds)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case E_OR: {
                List<Element> children = this.getChildElements(e);
                int i = 0;
                while (i < children.size()) {
                    if (this.matchesElement(children.get(i), ds)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case E_NOT: {
                return !this.matchesElement(this.getChildElements(e).get(0), ds);
            }
            case E_EQUAL: {
                String a = this.attrValue(e, ATTR_A, ds);
                String b = this.attrValue(e, ATTR_B, ds);
                if (this.isNum(a) && this.isNum(b)) {
                    return Double.parseDouble(a) == Double.parseDouble(b);
                }
                return a.equals(b);
            }
            case E_GREATERTHAN: 
            case E_LESSTHAN: {
                String a = this.attrValue(e, ATTR_A, ds);
                String b = this.attrValue(e, ATTR_B, ds);
                Double da = Double.parseDouble(a);
                Double db = Double.parseDouble(b);
                if (typ == ElementTyp.E_GREATERTHAN && da > db) {
                    return true;
                }
                return typ == ElementTyp.E_LESSTHAN && da < db;
            }
        }
        Log.get((String)"Messwertstatistiken").log("Ungueltige Operation: " + e.getTagName(), 2);
        return false;
    }

    public boolean matches(Datensatz ds) throws PluginstatistikException {
        return this.matchesElement(this.element, ds);
    }

    static enum ElementTyp {
        E_INVALID,
        E_NOT,
        E_AND,
        E_OR,
        E_EQUAL,
        E_GREATERTHAN,
        E_LESSTHAN;

    }
}

