/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.pluginstatistiken.config;

import com.hilotec.elexis.pluginstatistiken.Datensatz;
import com.hilotec.elexis.pluginstatistiken.PluginstatistikException;
import com.hilotec.elexis.pluginstatistiken.config.Konfiguration;
import com.hilotec.elexis.pluginstatistiken.config.KonfigurationWhere;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatenquelle;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.IDatensatz;
import com.hilotec.elexis.pluginstatistiken.schnittstelle.ITabelle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class KonfigurationQuery {
    String title;
    String from;
    String fromAs;
    KonfigurationWhere where = null;
    List<String> colsName;
    List<String> colsSource;
    List<Join> joins;

    public KonfigurationQuery(String t) {
        this.title = t;
        this.colsName = new ArrayList<String>();
        this.colsSource = new ArrayList<String>();
        this.joins = new LinkedList<Join>();
    }

    public void setFrom(String table, String as) {
        this.from = table;
        this.fromAs = as;
    }

    public void addCol(String name, String source) {
        this.colsName.add(name);
        this.colsSource.add(source);
    }

    public List<String> getColNames() {
        return this.colsName;
    }

    public List<String> getColSources() {
        return this.colsSource;
    }

    public void setWhere(KonfigurationWhere w) {
        this.where = w;
    }

    public void addJoin(Join j) {
        this.joins.add(j);
    }

    public String getTitle() {
        return this.title;
    }

    private ITabelle getTabelle(String name) throws PluginstatistikException {
        String[] fromParts = name.split(":");
        if (fromParts.length < 2) {
            throw new PluginstatistikException("Abfrage: Tabellenbezeichner ungueltig formatiert: '" + this.from + "'");
        }
        String dqPart = fromParts[0];
        String tabPart = fromParts[1];
        IDatenquelle dq = Konfiguration.getInstance().getDatenquelle(dqPart);
        if (dq == null) {
            throw new PluginstatistikException("Abfrage: Unbekannte Datenquelle: '" + dqPart + "'");
        }
        ITabelle t = dq.getTabelle(tabPart);
        if (t == null) {
            throw new PluginstatistikException("Abfrage: Unbekannte Tabelle: '" + tabPart + "' (in  Datenquelle '" + dqPart + "')");
        }
        return t;
    }

    public List<Datensatz> getDaten(String startDatum, String endDatum, IProgressMonitor monitor) throws PluginstatistikException {
        LinkedList<Datensatz> data = new LinkedList<Datensatz>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("startdatum", startDatum);
        parameters.put("enddatum", endDatum);
        monitor.beginTask("Initialisiere Datenquelle", 1);
        ITabelle from = this.getTabelle(this.from);
        monitor.done();
        monitor.beginTask("Sammle Datensaetze", 1);
        List<IDatensatz> dsl = from.getDatensaetze();
        monitor.done();
        monitor.beginTask("Verarbeite Datens\u00e4tze", dsl.size());
        for (IDatensatz fromDs : dsl) {
            Datensatz ds = new Datensatz(this, startDatum, endDatum);
            int i = 0;
            while (i < this.colsName.size()) {
                ds.addSpalte(this.colsName.get(i), this.colsSource.get(i));
                ++i;
            }
            ds.addIntDs(this.fromAs, fromDs);
            this.joinTable(ds, this.joins, data);
            monitor.worked(1);
        }
        monitor.done();
        return data;
    }

    private void joinTable(Datensatz ds, List<Join> joinsTodo, List<Datensatz> result) throws PluginstatistikException {
        if (joinsTodo == null || joinsTodo.size() == 0) {
            if (this.where == null || this.where.matches(ds)) {
                result.add(ds);
            }
        } else {
            Join j = joinsTodo.get(0);
            LinkedList<Join> newTodo = null;
            if (joinsTodo.size() > 1) {
                newTodo = new LinkedList<Join>(joinsTodo);
                newTodo.remove(0);
            }
            ITabelle tab = this.getTabelle(j.getTable());
            List<IDatensatz> dsl = tab.getDatensaetze();
            for (IDatensatz ids : dsl) {
                Datensatz tmpDs = new Datensatz(ds);
                tmpDs.addIntDs(j.getAs(), ids);
                if (!j.getWhere().matches(tmpDs)) continue;
                this.joinTable(tmpDs, newTodo, result);
            }
        }
    }

    public static class Join {
        String table;
        String as;
        KonfigurationWhere where;
        JType type;

        public Join(String table, String as, KonfigurationWhere w, JType typ) {
            this.table = table;
            this.as = as;
            this.where = w;
        }

        public String getTable() {
            return this.table;
        }

        public String getAs() {
            return this.as;
        }

        public KonfigurationWhere getWhere() {
            return this.where;
        }

        static enum JType {
            JOIN_INNER;

        }
    }
}

