/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.pluginstatistiken;

import ch.rgw.tools.Log;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import com.hilotec.elexis.pluginstatistiken.Datensatz;
import com.hilotec.elexis.pluginstatistiken.OurComboWidget;
import com.hilotec.elexis.pluginstatistiken.PluginstatistikException;
import com.hilotec.elexis.pluginstatistiken.config.Konfiguration;
import com.hilotec.elexis.pluginstatistiken.config.KonfigurationQuery;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PluginDataProvider
extends AbstractTimeSeries {
    Konfiguration konfig = Konfiguration.getInstance();
    KonfigurationQuery query = null;
    String currentQuery;
    String[] queries;
    private static final String DATE_PRESCRIPTION_FORMAT = "dd.MM.yyyy";

    public PluginDataProvider() {
        super("Pluginstatistiken");
        List<KonfigurationQuery> ql = this.konfig.getQueries();
        this.queries = new String[ql.size()];
        int i = 0;
        for (KonfigurationQuery kq : ql) {
            this.queries[i++] = kq.getTitle();
        }
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        List<Datensatz> data;
        if (this.query == null) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<Comparable[]> content = new ArrayList<Comparable[]>();
        SimpleDateFormat gerFormat = new SimpleDateFormat(DATE_PRESCRIPTION_FORMAT);
        try {
            data = this.query.getDaten(gerFormat.format(this.getStartDate().getTime()), gerFormat.format(this.getEndDate().getTime()), monitor);
        }
        catch (PluginstatistikException e) {
            Log.get((String)"Messwertstatistiken").log(e.getMessage(), 2);
            return Status.CANCEL_STATUS;
        }
        List<String> names = this.query.getColNames();
        for (Datensatz ds : data) {
            Comparable[] row = new Comparable[names.size()];
            int i = 0;
            while (i < names.size()) {
                row[i] = ds.getFeld(names.get(i));
                ++i;
            }
            content.add(row);
        }
        this.dataSet.setContent(content);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected List<String> createHeadings() {
        return this.query.getColNames();
    }

    public String getDescription() {
        return "Pluginstatistiken";
    }

    @GetProperty(name="Abfrage", index=0, description="Zu benutzende Abfrage um die Daten zu sammeln", widgetType=WidgetTypes.VENDOR, vendorClass=OurComboWidget.class)
    public String getAbfrage() {
        if (this.query == null) {
            return this.queries[0];
        }
        return this.query.getTitle();
    }

    @SetProperty(name="Abfrage")
    public void setAbfrage(String q) {
        List<KonfigurationQuery> queries = this.konfig.getQueries();
        int i = 0;
        while (i < queries.size()) {
            if (queries.get(i).getTitle().equals(q)) {
                this.query = queries.get(i);
                break;
            }
            ++i;
        }
    }
}

