/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.views;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.UriType;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.service.IFindingsTemplateService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.commands.UpdateFindingTextCommand;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.extensions.Service;
import org.slf4j.LoggerFactory;

public class ObservationMigrator {
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Inject
    private IFindingsTemplateService findigsTemplateService;
    private Map<String, FindingsTemplate> templatesMap;
    private Properties mappingProperties;

    public ObservationMigrator() {
        CoreUiUtil.injectServices((Object)this);
        this.templatesMap = new HashMap<String, FindingsTemplate>();
        FindingsTemplates defaultTemplates = this.findigsTemplateService.getFindingsTemplates("Standard Vorlagen");
        if (defaultTemplates.getFindingsTemplates().isEmpty()) {
            try {
                this.findigsTemplateService.importTemplateFromFile(this.getDefaultTemplatesFilePath());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error importing default templates", (Throwable)e);
            }
        }
        this.mappingProperties = new Properties();
        try {
            this.mappingProperties.load(this.getClass().getResourceAsStream("/rsc/migration/mapping.properties"));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not load mapping properties.", (Throwable)e);
        }
    }

    public void loadProperties(String filename) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(filename);){
                this.mappingProperties.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not load mapping properties.", (Throwable)e);
        }
    }

    private String getDefaultTemplatesFilePath() {
        File tmpFile = new File(CoreUtil.getTempDir(), "befundvorlage_default.xml");
        tmpFile.deleteOnExit();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fout = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/rsc/migration/befundvorlage_default.xml"), (OutputStream)fout);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not export default templates.", (Throwable)e);
            return null;
        }
        return tmpFile.getAbsolutePath();
    }

    public void migrate(IProgressMonitor monitor) {
        MessungKonfiguration.getInstance().readFromXML();
        List allPatients = new Query(Patient.class).execute();
        monitor.beginTask("Hilotec Messwerte Migration", allPatients.size());
        for (Patient patient : allPatients) {
            List<Messung> allMessungen = Messung.getPatientMessungen(patient, null);
            for (Messung messung : allMessungen) {
                TimeTool messungDatum = new TimeTool(messung.getDatum());
                ArrayList<IObservation> createdObservations = new ArrayList<IObservation>();
                for (Messwert messwert : messung.getMesswerte()) {
                    Optional<FindingsTemplate> template;
                    if (!this.hasValue(messwert) || !(template = this.getTemplateMapping(messwert.getName())).isPresent()) continue;
                    String mappedCode = this.mappingProperties.getProperty(messwert.getName());
                    try {
                        IObservation observation = null;
                        if (this.isMappedCodeComponent(mappedCode)) {
                            String componentCode;
                            observation = this.getCreatedObservation(createdObservations, this.getMappedCodeNoComponent(mappedCode));
                            if (observation == null) {
                                observation = (IObservation)this.findigsTemplateService.createFinding(patient.toIPatient(), template.get());
                                createdObservations.add(observation);
                            }
                            if (StringUtils.isNotBlank((CharSequence)(componentCode = this.getMappedCodeComponent(mappedCode)))) {
                                List components = observation.getComponents();
                                for (ObservationComponent observationComponent : components) {
                                    if (!ModelUtil.isCodeInList((String)CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), (String)componentCode, (List)observationComponent.getCoding())) continue;
                                    this.setValue(observationComponent, messwert.getWert());
                                    observation.updateComponent(observationComponent);
                                    break;
                                }
                            }
                        } else {
                            observation = (IObservation)this.findigsTemplateService.createFinding(patient.toIPatient(), template.get());
                            this.setValue(observation, messwert.getWert());
                        }
                        observation.setEffectiveTime(messungDatum.toLocalDateTime());
                        observation.setOriginUri(UriType.DB.toString(messwert.storeToString()));
                        messwert.delete();
                        try {
                            new UpdateFindingTextCommand((IFinding)observation).execute();
                        }
                        catch (ElexisException e) {
                            LoggerFactory.getLogger(this.getClass()).warn("Updating finding text failed");
                        }
                    }
                    catch (ElexisException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error creating finding for messwert '{}'", (Object)messwert.getName(), (Object)e);
                    }
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private boolean hasValue(Messwert messwert) {
        if (StringUtils.isNotBlank((CharSequence)messwert.getWert())) {
            String value = messwert.getWert().trim();
            return !"0".equals(value);
        }
        return false;
    }

    private void setValue(IObservation observation, String value) {
        IObservation.ObservationType type = observation.getObservationType();
        if (type == IObservation.ObservationType.NUMERIC) {
            observation.setNumericValue(this.getNumericValue(value), observation.getNumericValueUnit().orElse(""));
        } else if (type == IObservation.ObservationType.TEXT) {
            observation.setStringValue(value);
        }
    }

    private void setValue(ObservationComponent observationComponent, String value) {
        IObservation.ObservationType type = (IObservation.ObservationType)observationComponent.getTypeFromExtension(IObservation.ObservationType.class);
        if (type == IObservation.ObservationType.NUMERIC) {
            observationComponent.setNumericValue(this.getNumericValue(value));
        } else if (type == IObservation.ObservationType.TEXT) {
            observationComponent.setStringValue(value);
        }
    }

    private IObservation getCreatedObservation(List<IObservation> createdObservations, String componentGrpCode) {
        for (IObservation iObservation : createdObservations) {
            if (!ModelUtil.isCodeInList((String)CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), (String)componentGrpCode, (List)iObservation.getCoding())) continue;
            return iObservation;
        }
        return null;
    }

    private Optional<FindingsTemplate> getTemplateMapping(String name) {
        String mappedCode = this.mappingProperties.getProperty(name);
        if (StringUtils.isNotBlank((CharSequence)mappedCode)) {
            FindingsTemplate template = this.templatesMap.get(mappedCode = this.getMappedCodeNoComponent(mappedCode));
            if (template == null && (template = (FindingsTemplate)this.findigsTemplateService.getFindingsTemplate((ICoding)new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), mappedCode, "")).orElse(null)) != null) {
                this.templatesMap.put(mappedCode, template);
            }
            return Optional.ofNullable(template);
        }
        return Optional.empty();
    }

    private boolean isMappedCodeComponent(String mappedCode) {
        return mappedCode.indexOf(".") > 0;
    }

    private String getMappedCodeComponent(String mappedCode) {
        return mappedCode.substring(mappedCode.indexOf(".") + 1);
    }

    private String getMappedCodeNoComponent(String mappedCode) {
        if (mappedCode.indexOf(".") > 0) {
            return mappedCode.substring(0, mappedCode.indexOf("."));
        }
        return mappedCode;
    }

    public BigDecimal getNumericValue(String result) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = result.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c) && c != '.' && c != ',') break;
            sb.append(c);
            ++n2;
        }
        if (sb.length() > 0) {
            Object value = sb.toString().replaceAll(",", ".");
            if (((String)value).startsWith(".")) {
                value = "0" + (String)value;
            }
            if (((String)value).endsWith(".")) {
                value = (String)value + "0";
            }
            try {
                return new BigDecimal((String)value);
            }
            catch (NumberFormatException ne) {
                LoggerFactory.getLogger(this.getClass()).error("Could not parse numeric result [" + result + "] value [" + (String)value + "]");
            }
        }
        return null;
    }
}

