/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.messwerte.v2.data.MessungKonfiguration;
import com.hilotec.elexis.messwerte.v2.data.MessungTyp;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import java.util.ArrayList;
import java.util.List;

public class Messung
extends PersistentObject {
    private static final String VERSION = "3";
    public static final String PLUGIN_ID = "com.hilotec.elexis.messwerte.v2";
    private static final String TABLENAME = "COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN";
    private static final String setVersionSQL = "UPDATE COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN SET TypName='3' WHERE ID='VERSION'; ";
    private static final String index1SQL = "CREATE INDEX idx1 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (PatientID);";
    private static final String index2SQL = "CREATE INDEX idx2 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (Datum);";
    private static final String index3SQL = "CREATE INDEX idx3 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (PatientID, Datum);";
    private static final String lengthTypName = "ALTER TABLE COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN MODIFY TypName VARCHAR(255);";
    private static final String create = "CREATE TABLE COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (  ID\t\t\tVARCHAR(25) PRIMARY KEY,   lastupdate \tBIGINT,   deleted\t\tCHAR(1) DEFAULT '0',   PatientID\tVARCHAR(25),   TypName\t\tVARCHAR(255),   Datum\t\tCHAR(8) );INSERT INTO COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (ID, TypName) VALUES \t('VERSION', '3');CREATE INDEX idx1 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (PatientID);CREATE INDEX idx2 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (Datum);CREATE INDEX idx3 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSUNGEN (PatientID, Datum);";

    static {
        Messung.addMapping((String)TABLENAME, (String[])new String[]{"PatientID", "TypName", "Datum=S:D:Datum"});
        Messung.checkTable();
    }

    private static void checkTable() {
        Messung check = Messung.load("VERSION");
        if (!check.exists()) {
            Messung.createOrModifyTable((String)create);
        }
        try {
            int ver = Integer.parseInt(check.get("TypName"));
            switch (ver) {
                case 1: {
                    Messung.updateToVersion3();
                    Messung.createOrModifyTable((String)setVersionSQL);
                    break;
                }
                case 2: {
                    Messung.updateToVersion3();
                    Messung.createOrModifyTable((String)setVersionSQL);
                }
            }
        }
        catch (Exception e) {
            SWTHelper.showError((String)Messages.DBError, (String)String.format(Messages.DBErrorTable, TABLENAME));
        }
    }

    private static void updateToVersion3() {
        Messung.createOrModifyTable((String)lengthTypName);
        Messung.createOrModifyTable((String)index1SQL);
        Messung.createOrModifyTable((String)index2SQL);
        Messung.createOrModifyTable((String)index3SQL);
    }

    public String getLabel() {
        return this.get("TypName");
    }

    public String getTableName() {
        return TABLENAME;
    }

    protected Messung() {
    }

    protected Messung(String id) {
        super(id);
    }

    public Messung(Patient patient, MessungTyp typ) {
        this.create(null);
        this.set("PatientID", patient.getId());
        this.set("TypName", typ.getName());
        this.set("Datum", new TimeTool().toString(4));
        this.set("deleted", "1");
    }

    public static Messung load(String id) {
        return new Messung(id);
    }

    public String getDatum() {
        return this.get("Datum");
    }

    public Messwert getMesswert(String name) {
        return this.getMesswert(name, true);
    }

    public Messwert getMesswert(String name, boolean create) {
        Query query = new Query(Messwert.class);
        query.add("MessungID", "=", this.getId());
        query.and();
        query.add("Name", "=", name);
        List list = query.execute();
        if (list.size() == 0) {
            if (create) {
                return new Messwert(this, name);
            }
            return null;
        }
        return (Messwert)((Object)list.get(0));
    }

    public List<Messwert> getMesswerte() {
        ArrayList<Messwert> messwerte = new ArrayList<Messwert>();
        MessungTyp typ = this.getTyp();
        if (typ != null) {
            ArrayList<IMesswertTyp> fields = typ.getMesswertTypen();
            for (IMesswertTyp dft : fields) {
                messwerte.add(this.getMesswert(dft.getName()));
            }
        }
        return messwerte;
    }

    public void setDatum(String datum) {
        this.set("Datum", datum);
    }

    public MessungTyp getTyp() {
        MessungKonfiguration config = MessungKonfiguration.getInstance();
        return config.getTypeByName(this.get("TypName"));
    }

    public Patient getPatient() {
        return Patient.load((String)this.get("PatientID"));
    }

    public static List<Messung> getPatientMessungen(Patient patient, MessungTyp typ) {
        Query query = new Query(Messung.class);
        query.add("PatientID", "=", patient.getId());
        if (typ != null) {
            query.and();
            query.add("TypName", "=", typ.getName());
        }
        query.orderBy(true, new String[]{"Datum"});
        return query.execute();
    }

    public static List<Messung> getAllePatientMessungen(Patient patient) {
        Query query = new Query(Messung.class);
        query.add("PatientID", "=", patient.getId());
        query.orderBy(true, new String[]{"Datum"});
        return query.execute();
    }

    public static List<Messung> getMessungen(MessungTyp typ) {
        Query query = new Query(Messung.class);
        query.add("TypName", "=", typ.getName());
        return query.execute();
    }

    public static List<Messung> getMessungenForExport(MessungTyp t, TimeTool dateFrom, TimeTool dateTo) {
        dateTo.addDays(1);
        Query query = new Query(Messung.class);
        query.add("TypName", "=", t.getName());
        query.add("Datum", ">=", dateFrom.toDBString(false));
        query.add("Datum", "<", dateTo.toDBString(false));
        query.orderBy(true, new String[]{"Datum", "PatientID"});
        return query.execute();
    }
}

