/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import com.hilotec.elexis.messwerte.v2.data.Messung;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.views.Messages;
import org.eclipse.swt.widgets.Label;

public class Messwert
extends PersistentObject {
    public static final String VERSION = "3";
    public static final String PLUGIN_ID = "com.hilotec.elexis.messwerte.v2";
    private static final String TABLENAME = "COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE";
    private Label iconLabel = null;
    private static final String setVersionSQL = "UPDATE COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE SET Name='3' WHERE ID='VERSION'; ";
    private static final String index1SQL = "CREATE INDEX idx1 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (MessungID);";
    private static final String index2SQL = "CREATE INDEX idx2 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (Name);";
    private static final String index3SQL = "CREATE INDEX idx3 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (MessungID, Name);";
    private static final String lengthName = "ALTER TABLE COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE MODIFY Name VARCHAR(255);";
    private static final String lengthWert = "ALTER TABLE COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE MODIFY Wert VARCHAR(255);";
    private static final String create = "CREATE TABLE COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (  ID\t\t\tVARCHAR(25) PRIMARY KEY,   lastupdate \tBIGINT,   deleted\t\tCHAR(1) DEFAULT '0',   MessungID\tVARCHAR(25),   Name\t\t\tVARCHAR(255),   Wert\t\t\tVARCHAR(255) );INSERT INTO COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (ID, Name) VALUES \t('VERSION', '3');CREATE INDEX idx1 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (MessungID);CREATE INDEX idx2 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (Name);CREATE INDEX idx3 on COM_HILOTEC_ELEXIS_MESSWERTE_MESSWERTE (MessungID, Name);";

    static {
        Messwert.addMapping((String)TABLENAME, (String[])new String[]{"MessungID", "Name", "Wert"});
        Messwert.checkTable();
    }

    private static void checkTable() {
        Messwert check = Messwert.load("VERSION");
        if (!check.exists()) {
            Messwert.createOrModifyTable((String)create);
        }
        try {
            int ver = Integer.parseInt(check.get("Name"));
            switch (ver) {
                case 1: {
                    Messwert.updateToVersion3();
                    Messwert.createOrModifyTable((String)setVersionSQL);
                    break;
                }
                case 2: {
                    Messwert.updateToVersion3();
                    Messwert.createOrModifyTable((String)setVersionSQL);
                }
            }
        }
        catch (Exception e) {
            SWTHelper.showError((String)Messages.DBError, (String)String.format(Messages.DBErrorTable, TABLENAME));
        }
    }

    private static void updateToVersion3() {
        Messwert.createOrModifyTable((String)lengthName);
        Messwert.createOrModifyTable((String)lengthWert);
        Messwert.createOrModifyTable((String)index1SQL);
        Messwert.createOrModifyTable((String)index2SQL);
        Messwert.createOrModifyTable((String)index3SQL);
    }

    public String getLabel() {
        return this.get("Name");
    }

    public String getTableName() {
        return TABLENAME;
    }

    protected Messwert() {
    }

    protected Messwert(String id) {
        super(id);
    }

    public Messwert(Messung messung, String name, String wert) {
        this.create(null);
        this.set("MessungID", messung.getId());
        this.set("Name", name);
        this.set("Wert", wert);
    }

    public Messwert(Messung messung, String name) {
        this.create(null);
        this.set("MessungID", messung.getId());
        this.set("Name", name);
        this.set("Wert", this.getTyp().getDefault(this));
    }

    public static Messwert load(String id) {
        return new Messwert(id);
    }

    public String getName() {
        return this.get("Name");
    }

    public String getWert() {
        return this.get("Wert");
    }

    public String getDarstellungswert() {
        return this.getTyp().getDarstellungswert(this.getWert());
    }

    public void setWert(String wert) {
        this.set("Wert", wert);
    }

    public Messung getMessung() {
        return new Messung(this.get("MessungID"));
    }

    public IMesswertTyp getTyp() {
        return this.getMessung().getTyp().getMesswertTyp(this.getName());
    }

    public void setIconLabel(Label il) {
        this.iconLabel = il;
    }

    public Label getIconLabel() {
        return this.iconLabel;
    }
}

