/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data.typen;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.util.SWTHelper;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.MesswertBase;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MesswertTypCount
extends MesswertBase
implements IMesswertTyp {
    private static final String CONFIG_BASE_NAME = "com/hilotec/messwerte/v2/";
    private String counterMode = "global_counter";
    private final DecimalFormat df = new DecimalFormat("#,000");
    private int startValue = 0;

    public MesswertTypCount(String n, String t, String u) {
        super(n, t, u);
        this.df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public String getFormatPattern() {
        return this.df.toPattern();
    }

    public void setFormatPattern(String pattern) {
        this.df.applyPattern(pattern);
    }

    @Override
    public String getDefault(Messwert messwert) {
        return "";
    }

    public void setCounterMode(String cn) {
        this.counterMode = cn;
    }

    @Override
    public void setDefault(String def) {
    }

    public void setStartValue(String sv) {
        this.startValue = Integer.parseInt(sv);
    }

    @Override
    public Widget createWidget(Composite parent, Messwert messwert) {
        this.widget = SWTHelper.createText((Composite)parent, (int)1, (int)0);
        ((Text)this.widget).setText(messwert.getWert());
        ((Text)this.widget).setEditable(false);
        this.setShown(true);
        return this.widget;
    }

    @Override
    public ActiveControl createControl(Composite parent, Messwert messwert, boolean bEditable) {
        return null;
    }

    @Override
    public void saveInput(Messwert messwert) {
        String s = messwert.getWert();
        if (s.equals("")) {
            int value = ConfigServiceHolder.getGlobal((String)(CONFIG_BASE_NAME + this.counterMode), (int)this.startValue);
            value = value < this.startValue ? this.startValue : ++value;
            ConfigServiceHolder.setGlobal((String)(CONFIG_BASE_NAME + this.counterMode), (int)value);
            messwert.setWert(this.df.format(value));
        }
    }

    @Override
    public String getDarstellungswert(String wert) {
        return wert;
    }

    @Override
    public boolean checkInput(Messwert messwert, String pattern) {
        super.checkInput(messwert, pattern);
        String value = ((Text)this.widget).getText();
        return value.matches(pattern) || pattern == null;
    }

    @Override
    public String erstelleDarstellungswert(Messwert messwert) {
        try {
            return this.df.format(Double.parseDouble(messwert.getWert()));
        }
        catch (Exception exception) {
            return "";
        }
    }
}

