/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.messwerte.v2.data.typen;

import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.TextField;
import ch.elexis.core.ui.util.SWTHelper;
import com.hilotec.elexis.messwerte.v2.data.Messwert;
import com.hilotec.elexis.messwerte.v2.data.MesswertBase;
import com.hilotec.elexis.messwerte.v2.data.typen.IMesswertTyp;
import com.hilotec.elexis.messwerte.v2.data.typen.Messages;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MesswertTypNum
extends MesswertBase
implements IMesswertTyp {
    double defVal = 0.0;
    private final DecimalFormat df = new DecimalFormat("#0.#");

    public MesswertTypNum(String n, String t, String u) {
        super(n, t, u);
        this.df.setRoundingMode(RoundingMode.HALF_UP);
    }

    @Override
    public String erstelleDarstellungswert(Messwert messwert) {
        try {
            return this.df.format(Double.parseDouble(messwert.getWert()));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getDefault(Messwert messwert) {
        Double dWert = this.defVal;
        if (this.formula != null) {
            String sWert = this.evalateFormula(this.formula, messwert, this.df.format(dWert));
            try {
                dWert = Double.parseDouble(sWert);
            }
            catch (Exception e) {
                this.log.log(MessageFormat.format(Messages.MesswertTypNum_CastFailure, sWert), 2);
            }
        }
        return this.df.format(dWert);
    }

    @Override
    public void setDefault(String str) {
        this.defVal = Double.parseDouble(str);
    }

    public String getFormatPattern() {
        return this.df.toPattern();
    }

    public void setFormatPattern(String pattern) {
        this.df.applyPattern(pattern);
    }

    public String getRoundingMode() {
        return this.df.getRoundingMode().toString();
    }

    public void setRoundingMode(String roundingMode) {
        this.df.setRoundingMode(RoundingMode.valueOf(roundingMode));
    }

    @Override
    public Widget createWidget(Composite parent, Messwert messwert) {
        this.widget = SWTHelper.createText((Composite)parent, (int)1, (int)4);
        try {
            ((Text)this.widget).setText(this.df.format(Double.parseDouble(messwert.getWert())));
        }
        catch (Exception e) {
            ((Text)this.widget).setText(messwert.getWert());
        }
        ((Text)this.widget).setEditable(this.editable);
        this.setShown(true);
        return this.widget;
    }

    @Override
    public String getDarstellungswert(String wert) {
        return wert;
    }

    @Override
    public String getActualValue() {
        String s = ((Text)this.widget).getText();
        if (s == "") {
            s = "0";
        }
        return s;
    }

    @Override
    public void saveInput(Messwert messwert) {
        messwert.setWert(((Text)this.widget).getText());
    }

    @Override
    public boolean checkInput(Messwert messwert, String pattern) {
        super.checkInput(messwert, pattern);
        String value = ((Text)this.widget).getText();
        return value.matches(pattern) || pattern == null;
    }

    @Override
    public ActiveControl createControl(Composite parent, Messwert messwert, boolean bEditable) {
        int flags = 0;
        if (!bEditable) {
            flags |= 8;
        }
        IMesswertTyp dft = messwert.getTyp();
        Object labelText = dft.getTitle();
        if (!dft.getUnit().equals("")) {
            labelText = (String)labelText + " [" + dft.getUnit() + "]";
        }
        if (((String)labelText).length() == 0) {
            flags |= 1;
        }
        TextField tf = new TextField(parent, flags, (String)labelText);
        tf.setText(messwert.getDarstellungswert());
        return tf;
    }
}

