/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.MultilineFieldEditor;
import com.hilotec.elexis.kgview.ArchivKGMigrator;
import com.hilotec.elexis.kgview.DiagnosisMigrator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class Preferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static ConfigServicePreferenceStore store = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.MANDATOR);
    public static final String CFG_EVLISTE = "hilotec/kgview/einnahmevorschriften";
    public static final String CFG_FLORDZ = "hilotec/kgview/ordnungszahlfavliste";
    public static final String CFG_MK_INCSTOP = "hilotec/kgview/mkincludestopdate";
    public static final String CFG_AKG_HEARTBEAT = "hilotec/kgview/archivkgheartbaeat";
    public static final String CFG_AKG_SCROLLPERIOD = "hilotec/kgview/archivkgscrollperiod";
    public static final String CFG_AKG_SCROLLDIST_UP = "hilotec/kgview/archivkgscrolldistup";
    public static final String CFG_AKG_SCROLLDIST_DOWN = "hilotec/kgview/archivkgscrolldistdown";

    static {
        store.setDefault(CFG_FLORDZ, false);
        store.setDefault(CFG_MK_INCSTOP, false);
        store.setDefault(CFG_AKG_HEARTBEAT, 10);
        store.setDefault(CFG_AKG_SCROLLPERIOD, 200);
        store.setDefault(CFG_AKG_SCROLLDIST_UP, 5);
        store.setDefault(CFG_AKG_SCROLLDIST_DOWN, 5);
    }

    public Preferences() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)store);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new MultilineFieldEditor(CFG_EVLISTE, "Einnahmevorschriften", 5, 512, true, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(CFG_FLORDZ, "Ordnungszahl in FML anzeigen", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(CFG_MK_INCSTOP, "In Medikarte bis/mit Stoppdatum anzeigen?", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_HEARTBEAT, "Archiv KG Heartbeat", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLPERIOD, "Archiv KG Scroll Periode [ms]", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLDIST_UP, "Archiv KG Scroll Distanz hoch [px]", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(CFG_AKG_SCROLLDIST_DOWN, "Archiv KG Scroll Distanz runter [px]", this.getFieldEditorParent()));
        Button migrationBtn = new Button(this.getFieldEditorParent().getParent(), 8);
        migrationBtn.setText("Diagnosen Migration");
        migrationBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Preferences.this.getShell());
                try {
                    progressDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            DiagnosisMigrator migrator = new DiagnosisMigrator();
                            migrator.migrate(monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)Preferences.this.getShell(), (String)"Diagnosen konvertieren", (String)"Fehler beim erzeugen der strukturierten Diagnosen.");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating structured diagnosis", (Throwable)e);
                }
            }
        });
        migrationBtn = new Button(this.getFieldEditorParent().getParent(), 8);
        migrationBtn.setText("ArchivKG Migration");
        migrationBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Preferences.this.getShell());
                try {
                    progressDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            ArchivKGMigrator migrator = new ArchivKGMigrator();
                            migrator.migrate(monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)Preferences.this.getShell(), (String)"ArchivKG konvertieren", (String)"Fehler beim migrieren der Konsultationen.");
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error migrating encounters", (Throwable)e);
                }
            }
        });
    }

    public static String[] getEinnahmevorschriften() {
        String s = ConfigServiceHolder.getMandator((String)CFG_EVLISTE, (String)"");
        return s.split(",");
    }

    public static boolean getOrdnungszahlInFML() {
        boolean oz = ConfigServiceHolder.getMandator((String)CFG_FLORDZ, (boolean)false);
        return oz;
    }

    public static boolean getMedikarteStopdatumInkl() {
        return store.getBoolean(CFG_MK_INCSTOP);
    }

    public int getArchivKGHeartbeat() {
        int n = store.getInt(CFG_AKG_HEARTBEAT);
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public static int getArchivKGScrollPeriod() {
        int n = store.getInt(CFG_AKG_SCROLLPERIOD);
        if (n < 50) {
            n = 50;
        }
        return n;
    }

    public static int getArchivKGScrollDistUp() {
        int n = store.getInt(CFG_AKG_SCROLLDIST_UP);
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public static int getArchivKGScrollDistDown() {
        int n = store.getInt(CFG_AKG_SCROLLDIST_DOWN);
        if (n < 1) {
            n = 1;
        }
        return n;
    }
}

