/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.diagnoseliste;

import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class DiagnoselisteItem
extends PersistentObject {
    public static final String VERSION = "2";
    public static final String PLUGIN_ID = "com.hilotec.elexis.kgview";
    private static final String TABLENAME = "COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE";
    public static final String FLD_PATIENT = "Patient";
    public static final String FLD_TYP = "Typ";
    public static final String FLD_SOURCE = "Source";
    public static final String FLD_PARENT = "Parent";
    public static final String FLD_POSITION = "Position";
    public static final String FLD_DATUM = "Datum";
    public static final String FLD_ICPC = "ICPC";
    public static final String FLD_TEXT = "Text";
    public static final int TYP_DIAGNOSELISTE = 0;
    public static final int TYP_PERSANAMNESE = 1;
    public static final int TYP_SYSANAMNESE = 2;
    private static final String create = "CREATE TABLE COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE (  ID\t\t\t\tVARCHAR(25) PRIMARY KEY,   lastupdate \tBIGINT,   deleted\t\tCHAR(1) DEFAULT '0',   Patient\t\tVARCHAR(25),   Typ            INT DEFAULT 0,   Source\t \t\tVARCHAR(25),   Parent\t \t\tVARCHAR(25),   Position\t\tINT DEFAULT 0,   Datum          CHAR(8) DEFAULT '00000000',   ICPC           TEXT,   Text\t\t\tTEXT );INSERT INTO COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE (ID, Position) VALUES \t('VERSION', '2');";
    private static final String up_1to2 = "ALTER TABLE COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE  ADD Typ    INT DEFAULT 0               AFTER Patient,  ADD Source VARCHAR(25)                 AFTER Patient,  ADD Datum  CHAR(8)  DEFAULT '00000000' AFTER Position,  ADD ICPC   TEXT                        AFTER Position;UPDATE COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE SET Position = '2' WHERE  ID LIKE 'VERSION';";

    static {
        DiagnoselisteItem.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENT, FLD_TYP, FLD_SOURCE, FLD_PARENT, FLD_POSITION, "Datum=S:D:Datum", FLD_ICPC, FLD_TEXT});
        DiagnoselisteItem.checkTable();
    }

    private static void checkTable() {
        String fm = null;
        try {
            fm = DiagnoselisteItem.getConnection().queryString("SELECT Position FROM COM_HILOTEC_ELEXIS_KGVIEW_DIAGNOSE WHERE ID='VERSION';");
            if (fm.equals("1")) {
                DiagnoselisteItem.createOrModifyTable((String)up_1to2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fm == null) {
            DiagnoselisteItem.createOrModifyTable((String)create);
        }
    }

    protected DiagnoselisteItem(Patient pat, int typ) {
        this.create(null);
        this.setPatient(pat);
        this.setPosition(0);
        this.setTyp(typ);
        this.setDatum(new TimeTool().toString(4));
    }

    protected DiagnoselisteItem(DiagnoselisteItem parent, int pos) {
        this.create(null);
        this.setPatient(parent.getPatient());
        this.setParent(parent);
        this.setPosition(pos);
        this.setTyp(parent.getTyp());
        this.setDatum(new TimeTool().toString(4));
    }

    protected DiagnoselisteItem() {
    }

    protected DiagnoselisteItem(String id) {
        super(id);
    }

    public static DiagnoselisteItem load(String id) {
        DiagnoselisteItem di = new DiagnoselisteItem(id);
        if (!di.exists()) {
            return null;
        }
        return di;
    }

    public Patient getPatient() {
        return Patient.load((String)this.get(FLD_PATIENT));
    }

    public void setPatient(Patient pat) {
        if (pat == null) {
            this.set(FLD_PATIENT, null);
        } else {
            this.set(FLD_PATIENT, pat.getId());
        }
    }

    public int getTyp() {
        return this.getInt(FLD_TYP);
    }

    protected void setTyp(int typ) {
        this.setInt(FLD_TYP, typ);
    }

    public String getSource() {
        return this.get(FLD_SOURCE);
    }

    public void setSource(String src) {
        this.set(FLD_SOURCE, src);
    }

    public DiagnoselisteItem getParent() {
        String id = this.get(FLD_PARENT);
        if (id == null || id.isEmpty()) {
            return null;
        }
        return DiagnoselisteItem.load(id);
    }

    public void setParent(DiagnoselisteItem parent) {
        this.set(FLD_PARENT, parent.getId());
    }

    public int getPosition() {
        return Integer.parseInt(this.get(FLD_POSITION));
    }

    public void setPosition(int pos) {
        this.set(FLD_POSITION, Integer.toString(pos));
    }

    public String getDatum() {
        return this.get(FLD_DATUM);
    }

    public void setDatum(String datum) {
        this.set(FLD_DATUM, datum);
    }

    public String getText() {
        return StringTool.unNull((String)this.get(FLD_TEXT));
    }

    public void setText(String text) {
        this.set(FLD_TEXT, text);
    }

    public String getICPC() {
        return StringTool.unNull((String)this.get(FLD_ICPC));
    }

    public void setICPC(String icpc) {
        this.set(FLD_ICPC, icpc);
    }

    public int nextChildPos() {
        int next = 0;
        for (DiagnoselisteItem di : this.getChildren()) {
            next = Math.max(next, di.getPosition() + 1);
        }
        return next;
    }

    public List<DiagnoselisteItem> getChildren() {
        Query q = new Query(DiagnoselisteItem.class);
        q.add(FLD_PATIENT, "=", this.get(FLD_PATIENT));
        q.and();
        q.add(FLD_PARENT, "=", this.getId());
        q.orderBy(false, new String[]{FLD_POSITION});
        return q.execute();
    }

    public DiagnoselisteItem getBySrc(DiagnoselisteItem src) {
        Query q = new Query(DiagnoselisteItem.class);
        q.add(FLD_PATIENT, "=", this.get(FLD_PATIENT));
        q.and();
        q.add(FLD_SOURCE, "=", src.getId());
        List l = q.execute();
        if (l.isEmpty()) {
            return null;
        }
        return (DiagnoselisteItem)((Object)l.get(0));
    }

    public DiagnoselisteItem createChild() {
        return new DiagnoselisteItem(this, this.nextChildPos());
    }

    public DiagnoselisteItem createChildFrom(DiagnoselisteItem src) {
        DiagnoselisteItem i = this.createChild();
        i.setText(src.getText());
        i.setDatum(src.getDatum());
        i.setSource(src.getId());
        return i;
    }

    public static DiagnoselisteItem getRoot(Patient pat, int typ) {
        Query q = new Query(DiagnoselisteItem.class);
        q.add(FLD_PATIENT, "=", pat.getId());
        q.and();
        q.add(FLD_TYP, "=", Integer.toString(typ));
        q.add(FLD_PARENT, "=", null);
        List dis = q.execute();
        if (dis.isEmpty()) {
            return new DiagnoselisteItem(pat, typ);
        }
        return (DiagnoselisteItem)((Object)dis.get(0));
    }

    public void moveUp() {
        DiagnoselisteItem parent = this.getParent();
        if (parent == null) {
            return;
        }
        int pos = this.getPosition();
        if (pos == 0) {
            return;
        }
        --pos;
        for (DiagnoselisteItem di : parent.getChildren()) {
            if (di.getPosition() != pos) continue;
            di.setPosition(pos + 1);
            this.setPosition(pos);
            break;
        }
    }

    public boolean isDescendantOf(DiagnoselisteItem p) {
        if (this.equals((Object)p)) {
            return true;
        }
        DiagnoselisteItem par = this.getParent();
        if (par == null) {
            return false;
        }
        return par.isDescendantOf(p);
    }

    public void moveDown() {
        DiagnoselisteItem parent = this.getParent();
        if (parent == null) {
            return;
        }
        int pos = this.getPosition();
        ++pos;
        for (DiagnoselisteItem di : parent.getChildren()) {
            if (di.getPosition() != pos) continue;
            di.setPosition(pos - 1);
            this.setPosition(pos);
            break;
        }
    }

    public void removeChild(DiagnoselisteItem c) {
        int pos = c.getPosition();
        c.setPosition(this.nextChildPos());
        for (DiagnoselisteItem di : this.getChildren()) {
            int p = di.getPosition();
            if (p <= pos) continue;
            di.setPosition(p - 1);
        }
    }

    public boolean delete() {
        DiagnoselisteItem parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (super.delete()) {
            parent.removeChild(this);
        }
        return true;
    }

    public void deleteChildren() {
        for (DiagnoselisteItem i : this.getChildren()) {
            i.deleteChildren();
            i.delete();
        }
    }

    public String getLabel() {
        return this.getText();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public boolean isDragOK() {
        return true;
    }
}

