/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.data.KonsData;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NeueKonsDialog
extends TitleAreaDialog {
    DatePickerCombo datum;
    Text zeit;
    Combo typ;
    Konsultation kons;
    KonsData data;
    Fall fall;
    int neuTyp;
    String[] typenS = new String[]{"Regul\u00e4r", "Telefon", "Hausbesuch"};
    int[] typenI;

    public NeueKonsDialog(Shell parentShell, Fall fall, int typ) {
        super(parentShell);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.typenI = nArray;
        this.fall = fall;
        this.neuTyp = typ;
    }

    public NeueKonsDialog(Shell parentShell, Konsultation kons) {
        super(parentShell);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.typenI = nArray;
        this.kons = kons;
        this.data = new KonsData(kons);
        this.fall = kons.getFall();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0).setText("Patient");
        new Label(comp, 0).setText(this.fall.getPatient().getLabel());
        new Label(comp, 0).setText("Fall");
        new Label(comp, 0).setText(this.fall.getLabel());
        new Label(comp, 0).setText("Datum");
        this.datum = new DatePickerCombo(comp, 0);
        new Label(comp, 0).setText("Zeit");
        this.zeit = SWTHelper.createText((Composite)comp, (int)1, (int)2048);
        new Label(comp, 0).setText("Typ");
        this.typ = new Combo(comp, 4);
        String[] stringArray = this.typenS;
        int n = this.typenS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.typ.add(s);
            ++n2;
        }
        if (this.kons == null) {
            this.setTitle("Neue Konsultation erstellen");
            this.datum.setDate(new Date());
            this.zeit.setText(new TimeTool().toString(3));
        } else {
            this.setTitle("Konsultation modifizieren");
            TimeTool tt = new TimeTool(this.kons.getDatum());
            this.datum.setDate(tt.getTime());
            this.zeit.setText(this.data.getKonsBeginn());
            this.neuTyp = this.data.getKonsTyp();
        }
        int i = 0;
        while (i < this.typenI.length) {
            if (this.neuTyp == this.typenI[i]) {
                this.typ.select(i);
                break;
            }
            ++i;
        }
        return comp;
    }

    private void validateTime(String zeit) throws TimeTool.TimeFormatException {
        if (!zeit.matches("[0-9]{1,2}:[0-9]{1,2}")) {
            throw new TimeTool.TimeFormatException("");
        }
        String[] parts = zeit.split(":");
        if (Integer.parseInt(parts[0]) > 23 || Integer.parseInt(parts[1]) > 60) {
            throw new TimeTool.TimeFormatException("");
        }
    }

    public void okPressed() {
        TimeTool tt;
        Date d = this.datum.getDate();
        if (d == null || d.compareTo(new Date()) > 0) {
            this.setMessage("Es muss ein Datum ausgew\u00e4hlt werden. Darf nicht in der Zukunft liegen.");
            return;
        }
        try {
            String sZeit = this.zeit.getText();
            this.validateTime(sZeit);
            tt = new TimeTool(sZeit);
        }
        catch (TimeTool.TimeFormatException tfe) {
            this.setMessage("Es muss eine g\u00fcltige Startzeit (hh:mm) eingegeben werden.");
            return;
        }
        if (this.kons == null) {
            this.kons = this.fall.neueKonsultation();
            this.data = new KonsData(this.kons);
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)this.kons);
        }
        this.data.setKonsBeginn(tt.getTimeInMillis());
        this.kons.setDatum(new TimeTool(d.getTime()).toString(4), false);
        this.data.setKonsTyp(this.typenI[this.typ.getSelectionIndex()]);
        this.close();
    }
}

