/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.util.SWTHelper;
import com.hilotec.elexis.kgview.KonsTimeView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class KonsTimerView
extends KonsTimeView
implements Runnable {
    public static final String ID = "com.hilotec.elexis.kgview.KonsTimerView";
    private static final int DELAY = 1000;
    Button startBtn;
    Button setBtn;
    Button resetBtn;
    boolean timerRunning;

    @Override
    protected void createButtonControl(Composite parent) {
        Composite btns = new Composite(parent, 0);
        btns.setLayout((Layout)new GridLayout(2, false));
        this.startBtn = new Button(btns, 0);
        this.startBtn.setText("Start/Stop");
        this.startBtn.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                KonsTimerView.this.toggleTimer();
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.setBtn = new Button(btns, 0);
        this.setBtn.setText("\u00c4ndern");
        this.setBtn.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                IInputValidator iv = new IInputValidator(){

                    public String isValid(String newText) {
                        if (!newText.matches("(\\d{1,2}:)?\\d{1,2}:\\d{1,2}")) {
                            return "Format hh:mm:ss erwartet!";
                        }
                        return null;
                    }
                };
                InputDialog id = new InputDialog(KonsTimerView.this.getSite().getShell(), "Zeit \u00e4ndern", "Zeit des Timers \u00e4ndern", KonsTimerView.this.timerLbl.getText(), iv);
                if (id.open() == 0) {
                    String[] parts = id.getValue().split(":");
                    long f = 1000L;
                    KonsTimerView.this.time = 0L;
                    int i = parts.length - 1;
                    while (i >= 0) {
                        KonsTimerView.this.time += (long)Integer.parseInt(parts[i]) * f;
                        f *= 60L;
                        --i;
                    }
                    KonsTimerView.this.konsData.setKonsZeit(KonsTimerView.this.time);
                    KonsTimerView.this.updateLabel();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.resetBtn = new Button(btns, 0);
        this.resetBtn.setText("Reset");
        this.resetBtn.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (KonsTimerView.this.konsData != null && KonsTimerView.this.konsData.getKonsZeit() > 0L && SWTHelper.askYesNo((String)"Timer zur\u00fccksetzen", (String)"Soll der Konsultationstimer wirklich auf 00:00:00 zur\u00fcckgesetzt werden?")) {
                    KonsTimerView.this.resetTimer();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    @Override
    protected void setEnabled(boolean en) {
        if (!en) {
            this.timerLbl.setText("");
        }
        this.startBtn.setEnabled(en);
        this.resetBtn.setEnabled(en);
        this.setBtn.setEnabled(en);
    }

    private void update() {
        this.time += 1000L;
        this.konsData.setKonsZeit(this.time);
        this.updateLabel();
    }

    @Override
    protected void stopTimer() {
        Hub.getActiveShell().getDisplay().timerExec(-1, (Runnable)this);
        this.timerRunning = false;
        this.setBtn.setEnabled(true);
    }

    protected void toggleTimer() {
        if (this.timerRunning) {
            this.stopTimer();
        } else if (this.konsData != null) {
            Hub.getActiveShell().getDisplay().timerExec(1000, (Runnable)this);
            this.timerRunning = true;
            this.setBtn.setEnabled(false);
        }
    }

    protected void resetTimer() {
        this.stopTimer();
        if (this.konsData != null) {
            this.time = 0L;
            this.konsData.setKonsZeit(this.time);
            this.updateLabel();
        }
    }

    @Override
    public void run() {
        if (this.timerLbl.isDisposed()) {
            return;
        }
        this.update();
        Hub.getActiveShell().getDisplay().timerExec(1000, (Runnable)this);
    }
}

