/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.data.Prescription;
import ch.rgw.tools.TimeTool;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MedikarteStopDialog
extends TitleAreaDialog {
    private Prescription presc;
    private FavMedikament fm;
    private DatePickerCombo dpc;

    public MedikarteStopDialog(Shell parentShell, Prescription presc) {
        super(parentShell);
        this.presc = presc;
        this.fm = FavMedikament.load(presc.getArtikel());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Medikament stoppen");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lMed = new Label(comp, 0);
        lMed.setText("Medikament");
        Label medikament = new Label(comp, 2048);
        medikament.setText(this.fm.getLabel());
        Label lStart = new Label(comp, 0);
        lStart.setText("Startdatum");
        Label start = new Label(comp, 0);
        start.setText(this.presc.getBeginDate());
        Label lDatum = new Label(comp, 0);
        lDatum.setText("Stoppdatum");
        this.dpc = new DatePickerCombo(comp, 0);
        this.dpc.setDate(new Date());
        return comp;
    }

    public void okPressed() {
        TimeTool tStart = new TimeTool(this.presc.getBeginDate());
        TimeTool tStop = new TimeTool(this.dpc.getDate().getTime());
        if (tStop.compareTo((Calendar)tStart) < 0) {
            this.setMessage("Es kann kein Datum vor dem Startdatum angegeben werden!");
            return;
        }
        this.presc.setEndDate(tStop.toString(4));
        this.close();
    }
}

