/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview.medikarte;

import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import com.hilotec.elexis.kgview.Preferences;
import com.hilotec.elexis.kgview.data.FavMedikament;
import com.hilotec.elexis.kgview.medikarte.FavMedikamentDialog;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class FavMedikamentListe
extends ViewPart
implements IRefreshable {
    public static final String ID = "com.hilotec.elexis.kgview.medikarte.FavMedikamentListe";
    private Text suche;
    private Table table;
    private Action actEdit;
    private Action actDelete;
    private Action actCheckList;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(parent, 0);
        l.setText("Suche");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.suche = new Text(parent, 2048);
        this.suche.setLayoutData((Object)gd);
        this.suche.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FavMedikamentListe.this.refresh();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.table = new Table(parent, 66052);
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tc = new TableColumn(this.table, 0);
        tc.setText("Bezeichnung");
        tc.setWidth(180);
        tc = new TableColumn(this.table, 0);
        tc.setText("Zweck");
        tc.setWidth(180);
        tc = new TableColumn(this.table, 0);
        tc.setText("Einheit");
        tc.setWidth(40);
        if (Preferences.getOrdnungszahlInFML()) {
            tc = new TableColumn(this.table, 0);
            tc.setText("Ordnungszahl");
            tc.setWidth(40);
        }
        new PersistentObjectDropTarget((Control)this.table, new PersistentObjectDropTarget.IReceiver(){

            public void dropped(PersistentObject o, DropTargetEvent e) {
                Artikel a = (Artikel)o;
                new FavMedikamentDialog(FavMedikamentListe.this.getSite().getShell(), a).open();
            }

            public boolean accept(PersistentObject o) {
                if (o instanceof Artikel) {
                    Artikel a = (Artikel)o;
                    FavMedikament fm = FavMedikament.load(a.getId());
                    return fm == null;
                }
                return false;
            }
        });
        new PersistentObjectDragSource((Control)this.table, new PersistentObjectDragSource.ISelectionRenderer(){

            public List<PersistentObject> getSelection() {
                TableItem[] tis = FavMedikamentListe.this.table.getSelection();
                if (FavMedikamentListe.this.table.getSelection() == null) {
                    return null;
                }
                ArrayList<PersistentObject> res = new ArrayList<PersistentObject>(tis.length);
                TableItem[] tableItemArray = tis;
                int n = tis.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ti = tableItemArray[n2];
                    FavMedikament fm = (FavMedikament)((Object)ti.getData());
                    res.add((PersistentObject)fm.getArtikel());
                    ++n2;
                }
                return res;
            }
        });
        this.makeActions();
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                FavMedikamentListe.this.actEdit.run();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 127) {
                    return;
                }
                FavMedikamentListe.this.actDelete.run();
            }
        });
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(new IAction[]{this.actCheckList});
        menus.createControlContextMenu((Control)this.table, new IAction[]{this.actEdit, this.actDelete});
        this.refresh();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private String fmtVolltext(String text) {
        return text.replaceAll("[\\n\\r]+", ", ");
    }

    public void refresh() {
        Query qMeds = new Query(FavMedikament.class);
        qMeds.add("ID", "<>", "VERSION");
        String suchstring = this.suche.getText();
        if (!suchstring.isEmpty()) {
            qMeds.add("Bezeichnung", "LIKE", "%" + suchstring + "%");
        }
        qMeds.orderBy(false, new String[]{"Bezeichnung"});
        List meds = qMeds.execute();
        this.table.removeAll();
        for (FavMedikament med : meds) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setData((Object)med);
            ti.setText(0, med.getBezeichnung());
            ti.setText(1, this.fmtVolltext(med.getZweck()));
            ti.setText(2, med.getEinheit());
            if (!Preferences.getOrdnungszahlInFML()) continue;
            ti.setText(3, Integer.toString(med.getOrdnungszahl()));
        }
    }

    private static void checkFavMediList() {
        StringBuilder sb = new StringBuilder();
        for (FavMedikament fm : FavMedikament.getAll()) {
            Artikel art = fm.getArtikel();
            if (art.exists()) continue;
            String pk = art.get("SubID");
            if (pk == null || pk.isEmpty() || pk.equals("0")) {
                sb.append("Kann nicht verkn\u00fcpft werden: ");
                sb.append(fm.getBezeichnung());
                sb.append("\n");
                continue;
            }
            Query aq = new Query(Artikel.class);
            aq.clear();
            aq.add("SubID", "=", pk);
            List al = aq.execute();
            if (al.isEmpty()) {
                sb.append("Keine Alternative gefunden: ");
                sb.append(fm.getBezeichnung());
                sb.append("\n");
                continue;
            }
            boolean rl = false;
            for (Artikel na : al) {
                if (!SWTHelper.askYesNo((String)"Fav. Medikamente", (String)("Soll '" + fm.getBezeichnung() + "' neu mit '" + na.getName() + "' verkn\u00fcpft werden?"))) continue;
                fm.relinkTo(na);
                rl = true;
                break;
            }
            if (rl) continue;
            sb.append("Medikament nicht neu verknuepft: ");
            sb.append(fm.getBezeichnung());
            sb.append("\n");
        }
        if (sb.length() != 0) {
            SWTHelper.showInfo((String)"Favoriten Medikamenten-Listen check", (String)sb.toString());
        }
    }

    private void makeActions() {
        this.actEdit = new Action("Bearbeiten", 1){

            public void run() {
                TableItem[] tis = FavMedikamentListe.this.table.getSelection();
                if (tis == null || tis.length != 1) {
                    return;
                }
                new FavMedikamentDialog(FavMedikamentListe.this.getSite().getShell(), (FavMedikament)((Object)tis[0].getData())).open();
                FavMedikamentListe.this.refresh();
            }
        };
        this.actDelete = new Action("L\u00f6schen", 1){

            public void run() {
                TableItem[] tis = FavMedikamentListe.this.table.getSelection();
                if (tis == null || tis.length == 0) {
                    return;
                }
                if (!SWTHelper.askYesNo((String)"Medikament(e) aus Liste entfernen", (String)"Sollen das/die ausgew\u00e4hlte(n) Medikament(e) aus der Liste entfernt werden?")) {
                    return;
                }
                TableItem[] tableItemArray = tis;
                int n = tis.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ti = tableItemArray[n2];
                    FavMedikament fm = (FavMedikament)((Object)ti.getData());
                    fm.delete();
                    ++n2;
                }
                FavMedikamentListe.this.refresh();
            }
        };
        this.actCheckList = new Action("Liste pr\u00fcfen", 1){

            public void run() {
                FavMedikamentListe.checkFavMediList();
            }
        };
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    @Optional
    @Inject
    void crudFinding(@UIEventTopic(value="info/elexis/model/*") FavMedikament favMedikament) {
        CoreUiUtil.runAsyncIfActive(() -> this.refresh(), (Object)this.table);
    }
}

