/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public abstract class SimpleTextFView
extends ViewPart {
    private boolean canEdit = true;
    private Text textfield;
    private String origPName;
    protected Composite area;
    private boolean modifiable = false;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.area = new Composite(parent, 0);
        this.area.setLayout((Layout)new GridLayout());
        this.textfield = new Text(this.area, 578);
        this.modifiable = false;
        this.textfield.setEditable(this.modifiable);
        this.textfield.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SimpleTextFView.this.fieldChanged();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.textfield.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.textfield.setLayoutData((Object)gd);
        this.origPName = this.getPartName();
        this.initialize();
    }

    protected void initialize() {
    }

    public void setFocus() {
    }

    protected void setEnabled(boolean en) {
        this.modifiable = en && this.canEdit;
        this.textfield.setEditable(this.modifiable);
        if (!en) {
            this.setText("");
        }
    }

    protected boolean isEnabled() {
        return this.modifiable;
    }

    protected void setText(String text) {
        this.textfield.setText(text);
        this.setEmpty();
    }

    protected String getText() {
        return this.textfield.getText();
    }

    protected void setEmpty() {
        this.setPartName((this.isEmpty() ? "" : "* ") + this.origPName);
    }

    protected void fieldChanged() {
        this.setEmpty();
    }

    protected boolean isEmpty() {
        String text = this.textfield.getText();
        return text == null || text.isEmpty();
    }

    protected void setCanEdit(boolean edit) {
        this.canEdit = edit;
    }

    protected boolean getCanEdit() {
        return this.canEdit;
    }
}

