/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.kgview;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Konsultation;
import ch.elexis.icpc.model.icpc.IcpcCode;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.kgview.SimpleTextFView;
import com.hilotec.elexis.kgview.data.IcpcModelServiceHolder;
import com.hilotec.elexis.kgview.data.KonsData;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public abstract class KonsDataFView
extends SimpleTextFView
implements IRefreshable {
    protected final String dbfield;
    protected final String icpcfield;
    private KonsData data;
    private org.eclipse.swt.widgets.List icpc_list;
    private ArrayList<IcpcCode> code_list;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    protected KonsDataFView(String field) {
        this.dbfield = field;
        this.icpcfield = null;
    }

    protected KonsDataFView(String field, String icpc) {
        this.dbfield = field;
        this.icpcfield = icpc;
    }

    protected void clearIcpc() {
        if (this.icpcfield == null) {
            return;
        }
        this.icpc_list.removeAll();
        this.code_list.clear();
    }

    protected void storeIcpc() {
        if (this.icpcfield == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (IcpcCode c : this.code_list) {
            sb.append(c.getCode());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        this.data.set(this.icpcfield, sb.toString());
        this.setEmpty();
    }

    protected void loadIcpc() {
        String[] entries;
        if (this.icpcfield == null) {
            return;
        }
        this.clearIcpc();
        String[] stringArray = entries = StringTool.unNull((String)this.data.get(this.icpcfield)).split(",");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.length() != 0) {
                IcpcCode code = IcpcModelServiceHolder.get().load(c, IcpcCode.class).orElse(null);
                this.code_list.add(code);
                this.icpc_list.add(code.getLabel());
            }
            ++n2;
        }
    }

    private void removeIcpcCode() {
        if (this.icpcfield == null) {
            return;
        }
        int i = this.icpc_list.getSelectionIndex();
        if (i >= 0) {
            this.code_list.remove(i);
            this.icpc_list.remove(i);
            this.storeIcpc();
        }
        this.setEmpty();
    }

    @Override
    protected void initialize() {
        if (this.icpcfield != null) {
            GridData gd = new GridData();
            gd.verticalAlignment = 4;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.heightHint = 40;
            this.code_list = new ArrayList();
            this.icpc_list = new org.eclipse.swt.widgets.List(this.area, 512);
            this.icpc_list.setLayoutData((Object)gd);
            this.icpc_list.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode != 127) {
                        return;
                    }
                    KonsDataFView.this.removeIcpcCode();
                }
            });
            Menu m = new Menu((Control)this.icpc_list);
            MenuItem mi = new MenuItem(m, 0);
            mi.setText("Entfernen");
            mi.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    KonsDataFView.this.removeIcpcCode();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.icpc_list.setMenu(m);
            new GenericObjectDropTarget((Control)this.icpc_list, new GenericObjectDropTarget.IReceiver(){

                public void dropped(List<Object> list, DropTargetEvent e) {
                    for (Object o : list) {
                        IcpcCode code = (IcpcCode)o;
                        KonsDataFView.this.icpc_list.add(code.getLabel());
                        KonsDataFView.this.code_list.add(code);
                        KonsDataFView.this.storeIcpc();
                    }
                }

                public boolean accept(List<Object> list) {
                    for (Object o : list) {
                        if (o instanceof IcpcCode && !KonsDataFView.this.code_list.contains(o)) continue;
                        return false;
                    }
                    return KonsDataFView.this.isEnabled();
                }
            });
        }
        this.data = null;
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    @Override
    protected void fieldChanged() {
        super.fieldChanged();
        if (!this.isEnabled()) {
            return;
        }
        this.data.set(this.dbfield, this.getText());
    }

    @Override
    protected boolean isEmpty() {
        return super.isEmpty() && (this.code_list == null || this.code_list.isEmpty());
    }

    @Override
    protected void setEnabled(boolean en) {
        super.setEnabled(en);
        this.clearIcpc();
        if (this.icpcfield != null) {
            this.icpc_list.setEnabled(en && this.getCanEdit());
        }
    }

    private void konsDeselected() {
        this.setEnabled(false);
        this.data = null;
    }

    private void konsSelected(Konsultation kons) {
        this.data = new KonsData(kons);
        this.setCanEdit(this.data.isEditOK());
        this.setEnabled(true);
        this.loadIcpc();
        String text = StringTool.unNull((String)this.data.get(this.dbfield));
        this.setText(text);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    @Inject
    void activeEncounter(@Optional IEncounter encounter) {
        CoreUiUtil.runAsyncIfActive(() -> {
            Konsultation k = (Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)encounter);
            if (k != null) {
                this.konsSelected(k);
            } else {
                this.konsDeselected();
            }
        }, (Object)this.area);
    }

    public void refresh() {
        this.activeEncounter(ContextServiceHolder.get().getTyped(IEncounter.class).orElse(null));
    }
}

