/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.utils;

import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.unibe.iam.scg.archie.ArchieActivator;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseHelper {
    public static int getNumberOfPatients() {
        return DatabaseHelper.getTotalFromQuery("SELECT COUNT(ID) AS total FROM KONTAKT WHERE istPatient = '1' AND deleted = '0'", "total");
    }

    public static int getNumberOfConsultations() {
        return DatabaseHelper.getTotalFromQuery("SELECT COUNT(ID) AS total FROM BEHANDLUNGEN WHERE deleted = '0'", "total");
    }

    public static int getTotalNumberOfInvoices() {
        return DatabaseHelper.getTotalFromQuery("SELECT COUNT(ID) AS total FROM RECHNUNGEN where deleted = '0'", "total");
    }

    public static int getNumberOfInvoices(int status) {
        return DatabaseHelper.getTotalFromQuery("SELECT COUNT(id) AS total FROM RECHNUNGEN WHERE deleted = '0' AND RnStatus = '" + status + "'", "total");
    }

    public static int getNumberGenderPatients(String gender) {
        if (!gender.equals("m") && !gender.equals("w")) {
            throw new IllegalArgumentException("Gender has to be either m or w.");
        }
        JdbcLink link = PersistentObject.getConnection();
        JdbcLink.Stm statement = link.getStatement();
        ResultSet result = statement.query("SELECT Geschlecht, COUNT(ID) AS total FROM KONTAKT WHERE istPatient = '1' AND geschlecht = '" + gender + "' AND deleted = '0' GROUP BY Geschlecht");
        try {
            if (result != null && result.next()) {
                int n = result.getInt("total");
                return n;
            }
        }
        catch (SQLException e) {
            ArchieActivator.LOG.log("Error while trying to data from database.\n" + e.getLocalizedMessage(), 3);
            e.printStackTrace();
        }
        finally {
            link.releaseStatement(statement);
        }
        return 0;
    }

    private static int getTotalFromQuery(String query, String totalColumn) {
        JdbcLink link = PersistentObject.getConnection();
        JdbcLink.Stm statement = link.getStatement();
        ResultSet result = statement.query(query);
        try {
            if (result != null && result.next()) {
                int n = result.getInt(totalColumn);
                return n;
            }
        }
        catch (SQLException e) {
            ArchieActivator.LOG.log("Error while trying to data from database.\n" + e.getLocalizedMessage(), 3);
            e.printStackTrace();
        }
        finally {
            link.releaseStatement(statement);
        }
        return 0;
    }
}

