/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.wizards;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.controller.ChartModelManager;
import ch.unibe.iam.scg.archie.model.ChartModel;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.ui.widgets.TextWidget;
import ch.unibe.iam.scg.archie.ui.wizards.AbstractChartPage;
import ch.unibe.iam.scg.archie.ui.wizards.ChartWizard;
import ch.unibe.iam.scg.archie.utils.DatasetHelper;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PieChartPage
extends AbstractChartPage
implements Listener {
    protected static final String PAGE_NAME = "PieChartPage";
    private TextWidget chartName;
    private Combo keysColumn;
    private Combo valuesColumn;
    private Button threeDimensional;

    public PieChartPage() {
        super(PAGE_NAME, Messages.CHART_WIZARD_PIE_CHART_PAGE_TITLE, ArchieActivator.getImageDescriptor("icons/chart_pie_big.png"));
        super.setDescription(Messages.CHART_WIZARD_PIE_CHART_PAGE_DESCRIPTION);
    }

    public void handleEvent(Event event) {
        Status status = new Status(0, "Archie", 0, "", null);
        int valuesIndex = this.valuesColumn.getSelectionIndex();
        if (valuesIndex > -1) {
            String valueSelected = this.keysColumn.getItem(valuesIndex);
            DataSet dataset = ((ChartWizard)this.getWizard()).getModel().getDataSet();
            if (!DatasetHelper.isNumericColumn(dataset, valueSelected) && !DatasetHelper.isMoneyColumn(dataset, valueSelected)) {
                status = new Status(4, "Archie", 0, Messages.CHART_WIZARD_PIE_CHART_PAGE_ERROR_NUMERIC, null);
            }
        }
        this.applyToStatusLine((IStatus)status);
        this.getWizard().getContainer().updateButtons();
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.chartName = new TextWidget(container, 0, Messages.CHART_WIZARD_PIE_CHART_PAGE_TEXT_NAME, null);
        GridData nameLayoutData = new GridData(4, 4, true, false);
        nameLayoutData.horizontalSpan = 2;
        this.chartName.setLayoutData(nameLayoutData);
        List<String> columns = ((ChartWizard)this.getWizard()).getModel().getDataSet().getHeadings();
        Label keysLabel = new Label(container, 0);
        keysLabel.setText(Messages.CHART_WIZARD_PIE_CHART_PAGE_TEXT_KEYS);
        this.keysColumn = new Combo(container, 8);
        this.keysColumn.setItems(columns.toArray(new String[0]));
        Label valuesLabel = new Label(container, 0);
        valuesLabel.setText(Messages.CHART_WIZARD_PIE_CHART_PAGE_TEXT_VALUES);
        this.valuesColumn = new Combo(container, 8);
        this.valuesColumn.setItems(columns.toArray(new String[0]));
        Label threeDimensionalLabel = new Label(container, 0);
        threeDimensionalLabel.setText(Messages.CHART_WIZARD_PIE_CHART_TEXT_3D);
        this.threeDimensional = new Button(container, 32);
        this.threeDimensional.setToolTipText(Messages.CHART_WIZARD_PIE_CHART_TEXT_3D_TOOLTIP);
        this.chartName.addListener(2, this);
        this.keysColumn.addListener(13, (Listener)this);
        this.valuesColumn.addListener(13, (Listener)this);
        this.threeDimensional.addListener(13, (Listener)this);
        this.chartName.pack();
        int width = this.chartName.getLabel().getBounds().width;
        GridData widthData = new GridData();
        widthData.widthHint = width + 20;
        keysLabel.setLayoutData((Object)widthData);
        valuesLabel.setLayoutData((Object)widthData);
        threeDimensionalLabel.setLayoutData((Object)widthData);
        this.initializePreviousModelData();
        this.setControl((Control)container);
    }

    private void saveDataToModel() {
        ChartWizard wizard = (ChartWizard)this.getWizard();
        ChartModel chartModel = wizard.getModel();
        chartModel.setChartName(this.chartName.getValue().toString());
        chartModel.setKeysIndex(this.keysColumn.getSelectionIndex());
        chartModel.setValuesIndex(this.valuesColumn.getSelectionIndex());
        chartModel.setThreeDimensional(this.threeDimensional.getSelection());
    }

    private void initializePreviousModelData() {
        if (ChartModelManager.getInstance().hasPieChartModel()) {
            ChartModel model = ChartModelManager.getInstance().getPieChartModel();
            this.chartName.setValue(model.getChartName());
            this.keysColumn.select(model.getKeysIndex());
            this.valuesColumn.select(model.getValuesIndex());
            this.threeDimensional.setSelection(model.isThreeDimensional());
        }
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("ChartWizardMainPage");
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        return this.getWizard().getPage("ContentSelectionPage");
    }

    public boolean canFlipToNextPage() {
        return this.getErrorMessage() == null && this.keysColumn.getSelectionIndex() != -1 && this.valuesColumn.getSelectionIndex() != -1 && !this.chartName.getValue().toString().equals("");
    }
}

