/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.data.category.CategoryDataset;

public class HistogramTooltipGenerator
extends AbstractCategoryItemLabelGenerator
implements CategoryToolTipGenerator {
    private static final long serialVersionUID = -52348756900309688L;
    public static final String DEFAULT_TOOL_TIP_FORMAT_STRING = "({0}, {1}) = {2}";

    protected HistogramTooltipGenerator() {
        super(DEFAULT_TOOL_TIP_FORMAT_STRING, NumberFormat.getInstance());
    }

    public String generateToolTip(CategoryDataset dataset, int row, int column) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String result = null;
        Object[] items = this.createItemArray(dataset, row, column);
        result = MessageFormat.format(this.getLabelFormat(), items);
        return result;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] result = new Object[4];
        String nullValueString = "-";
        result[0] = dataset.getRowKey(row).toString();
        result[1] = dataset.getColumnKey(column).toString();
        Number value = dataset.getValue(row, column);
        result[2] = value != null ? Double.valueOf(value.doubleValue() < 0.0 ? -value.doubleValue() : value.doubleValue()) : nullValueString;
        return result;
    }
}

