/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.unibe.iam.scg.archie.model.Cohort;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class AgeHistogrammDatasetCreator
extends AbstractDatasetCreator {
    private static final int MALE_INDEX = 0;
    private static final int FEMALE_INDEX = 1;
    private int cohortSize;
    private boolean isEmpty;

    public AgeHistogrammDatasetCreator(String jobName, int cohortSize) {
        super(jobName);
        this.setCohortSize(cohortSize);
        this.isEmpty = true;
    }

    @Override
    public IStatus createContent(IProgressMonitor monitor) {
        this.dataset = new DefaultKeyedValues2DDataset();
        Query query = new Query(Patient.class);
        List patients = query.execute();
        this.isEmpty = patients.size() <= 0;
        monitor.beginTask("Querying Database...", patients.size());
        TreeMap<Cohort, Cohort> histogramm = new TreeMap<Cohort, Cohort>();
        for (Patient patient : patients) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            int age = 0;
            try {
                age = Integer.parseInt(patient.getAlter());
            }
            catch (NumberFormatException exception) {
                continue;
            }
            String gender = patient.getGeschlecht();
            if (!gender.equals("m") && !gender.equals("w")) continue;
            int lowerBound = age / this.cohortSize * this.cohortSize;
            int upperBound = lowerBound + this.cohortSize;
            Integer[] genderCount = new Integer[2];
            Cohort cohort = new Cohort(lowerBound, upperBound, genderCount);
            if (!histogramm.containsKey(cohort)) {
                if (gender.equals("m")) {
                    genderCount[0] = -1;
                    genderCount[1] = 0;
                    histogramm.put(cohort, cohort);
                } else {
                    genderCount[0] = 0;
                    genderCount[1] = 1;
                    histogramm.put(cohort, cohort);
                }
            } else if (gender.equals("m")) {
                genderCountTmp = (Integer[])((Cohort)histogramm.get(cohort)).getValue();
                genderCountTmp[0] = genderCountTmp[0] - 1;
            } else {
                genderCountTmp = (Integer[])((Cohort)histogramm.get(cohort)).getValue();
                genderCountTmp[1] = genderCountTmp[1] + 1;
            }
            monitor.worked(1);
        }
        for (Map.Entry entry : histogramm.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Integer[] genderCount = new Integer[2];
            genderCount = (Integer[])((Cohort)entry.getValue()).getValue();
            ((DefaultKeyedValues2DDataset)this.dataset).addValue((Number)genderCount[0], (Comparable)((Object)"Male"), (Comparable)entry.getKey());
            ((DefaultKeyedValues2DDataset)this.dataset).addValue((Number)genderCount[1], (Comparable)((Object)"Female"), (Comparable)entry.getKey());
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public void setCohortSize(int cohortSize) {
        this.cohortSize = cohortSize;
    }

    @Override
    protected boolean isDatasetEmpty() {
        return this.isEmpty;
    }
}

