/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.utils;

import ch.rgw.tools.Money;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.utils.ArrayUtils;
import ch.unibe.iam.scg.archie.utils.StringHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DatasetHelper {
    public static final void sortDataSet(DataSet dataset, String column, int direction) {
        int sortColumnIndex = DatasetHelper.getColumnIndex(dataset, column);
        assert (sortColumnIndex > -1);
        List<Comparable<?>[]> content = dataset.getContent();
        DatasetColumnComparator comparator = new DatasetColumnComparator();
        comparator.setSortColumn(sortColumnIndex);
        comparator.setSortDirection(direction);
        Collections.sort(content, comparator);
    }

    public static final boolean isMoneyColumn(DataSet dataset, String column) {
        int columnIndex = DatasetHelper.getColumnIndex(dataset, column);
        assert (columnIndex > -1);
        return DatasetHelper.isMoneyColumn(dataset, columnIndex);
    }

    public static final boolean isMoneyColumn(DataSet dataset, int columnIndex) {
        Comparable<?>[] col;
        Comparable<?>[] comparableArray = col = dataset.getColumn(columnIndex);
        int n = col.length;
        int n2 = 0;
        while (n2 < n) {
            Comparable<?> cell = comparableArray[n2];
            if (cell instanceof Money) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isNumericColumn(DataSet dataset, String column) {
        int columnIndex = DatasetHelper.getColumnIndex(dataset, column);
        assert (columnIndex > -1);
        return DatasetHelper.isNumericColumn(dataset, columnIndex);
    }

    public static final boolean isNumericColumn(DataSet dataset, int columnIndex) {
        Comparable<?>[] col = dataset.getColumn(columnIndex);
        if (col == null || col.length == 0) {
            return false;
        }
        Comparable<?>[] comparableArray = col;
        int n = col.length;
        int n2 = 0;
        while (n2 < n) {
            Comparable<?> cell = comparableArray[n2];
            if (cell != null && StringHelper.isNumeric(cell.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean hasNumericColumn(DataSet dataset) {
        boolean hasNumeric = false;
        for (String heading : dataset.getHeadings()) {
            if (!DatasetHelper.isNumericColumn(dataset, heading)) continue;
            hasNumeric = true;
            break;
        }
        return hasNumeric;
    }

    public static final boolean hasMoneyColumn(DataSet dataset) {
        boolean hasMoney = false;
        for (String heading : dataset.getHeadings()) {
            if (!DatasetHelper.isMoneyColumn(dataset, heading)) continue;
            hasMoney = true;
            break;
        }
        return hasMoney;
    }

    private static final int getColumnIndex(DataSet dataset, String column) {
        int columnIndex = -1;
        int i = 0;
        while (i < dataset.getHeadings().size()) {
            if (dataset.getHeadings().get(i).equals(column)) {
                columnIndex = i;
            }
            ++i;
        }
        return columnIndex;
    }

    public static class DatasetColumnComparator
    implements Comparator<Object> {
        private int sortColumn;
        private int sortDirection;

        @Override
        public int compare(Object e1, Object e2) {
            Object o1 = ((Object[])e1)[this.sortColumn];
            Object o2 = ((Object[])e2)[this.sortColumn];
            Class<?>[] o1interfaces = o1.getClass().getInterfaces();
            Class<?>[] o2interfaces = o2.getClass().getInterfaces();
            int result = ArrayUtils.hasInterface(o1interfaces, Comparable.class) && ArrayUtils.hasInterface(o2interfaces, Comparable.class) ? ((Comparable)o1).compareTo((Comparable)o2) : o1.toString().compareTo(o2.toString());
            return this.sortDirection == 1024 ? result * -1 : result;
        }

        public void setSortColumn(int column) {
            this.sortColumn = column;
        }

        public void setSortDirection(int direction) {
            this.sortDirection = direction;
        }
    }
}

