/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.wizards;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.model.ChartModel;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.ui.wizards.AbstractChartPage;
import ch.unibe.iam.scg.archie.ui.wizards.ChartWizard;
import ch.unibe.iam.scg.archie.utils.DatasetHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ChartWizardMainPage
extends AbstractChartPage
implements Listener {
    protected static final String PAGE_NAME = "ChartWizardMainPage";
    private ToolItem pieItem;
    private ToolItem barItem;

    protected ChartWizardMainPage() {
        super(PAGE_NAME, Messages.CHART_WIZARD_PAGE_TITLE, null);
        this.setDescription(Messages.CHART_WIZARD_PAGE_DESCRIPTION);
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData layoutData = new GridData(1808);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)layoutData);
        GridLayout toolbarLayout = new GridLayout();
        GridData toolbarLayoutData = new GridData(1808);
        toolbarLayoutData.grabExcessHorizontalSpace = true;
        toolbarLayoutData.grabExcessVerticalSpace = true;
        toolbarLayoutData.horizontalAlignment = 0x1000000;
        toolbarLayoutData.verticalAlignment = 0x1000000;
        ToolBar pieToolbar = new ToolBar(container, 0);
        ToolBar barToolbar = new ToolBar(container, 0);
        pieToolbar.setLayoutData((Object)toolbarLayoutData);
        pieToolbar.setLayout((Layout)toolbarLayout);
        barToolbar.setLayoutData((Object)toolbarLayoutData);
        barToolbar.setLayout((Layout)toolbarLayout);
        this.pieItem = new ToolItem(pieToolbar, 0x1000010);
        this.pieItem.setImage(ArchieActivator.getImage("chartPieBig"));
        this.pieItem.setText(Messages.CHART_WIZARD_PAGE_TEXT_PIE_CHART);
        this.pieItem.setEnabled(this.hasValidDataset());
        this.pieItem.addListener(13, (Listener)this);
        this.barItem = new ToolItem(barToolbar, 0x1000010);
        this.barItem.setImage(ArchieActivator.getImage("chartBarBig"));
        this.barItem.setText(Messages.CHART_WIZARD_PAGE_TEXT_BAR_CHART);
        this.barItem.setEnabled(this.hasValidDataset());
        this.barItem.addListener(13, (Listener)this);
        this.setControl((Control)container);
        this.applyToStatusLine(this.getErrorStatus());
    }

    public void handleEvent(Event event) {
        ToolItem eventItem = (ToolItem)event.widget;
        this.pieItem.setSelection(eventItem == this.pieItem);
        this.barItem.setSelection(eventItem == this.barItem);
        this.setModelChartType();
        this.getWizard().getContainer().updateButtons();
        this.setPageComplete(true);
    }

    private boolean hasValidDataset() {
        DataSet dataset = ((ChartWizard)this.getWizard()).getModel().getDataSet();
        return DatasetHelper.hasNumericColumn(dataset) || DatasetHelper.hasMoneyColumn(dataset);
    }

    private IStatus getErrorStatus() {
        Status status = new Status(0, "Archie", 0, "", null);
        if (!this.hasValidDataset()) {
            status = new Status(4, "Archie", 0, Messages.CHART_WIZARD_PAGE_ERROR_DATASET, null);
        }
        return status;
    }

    private void setModelChartType() {
        ChartModel model = ((ChartWizard)this.getWizard()).getModel();
        model.setChartType(this.pieItem.getSelection() ? 1 : 2);
    }

    public boolean canFlipToNextPage() {
        return ((ChartWizard)this.getWizard()).getModel().hasValidChartType() && this.hasValidDataset();
    }

    public IWizardPage getNextPage() {
        IWizard wizard = this.getWizard();
        return this.pieItem.getSelection() ? wizard.getPage("PieChartPage") : wizard.getPage("BarChartPage");
    }
}

