/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.wizards;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.controller.ChartModelManager;
import ch.unibe.iam.scg.archie.model.ChartModel;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.ui.widgets.TextWidget;
import ch.unibe.iam.scg.archie.ui.wizards.AbstractChartPage;
import ch.unibe.iam.scg.archie.ui.wizards.ChartWizard;
import ch.unibe.iam.scg.archie.utils.ArrayUtils;
import ch.unibe.iam.scg.archie.utils.DatasetHelper;
import ch.unibe.iam.scg.archie.utils.SWTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BarChartPage
extends AbstractChartPage
implements Listener {
    protected static final String PAGE_NAME = "BarChartPage";
    private static final int TYPE_BAR = 0;
    private static final int TYPE_LINE = 1;
    private TextWidget chartName;
    private Combo chartType;
    private Combo rowTitle;
    private HashMap<Button, Integer> columnButtons;
    private Button threeDimensional;

    public BarChartPage() {
        super(PAGE_NAME, Messages.CHART_WIZARD_BAR_CHART_PAGE_TITLE, ArchieActivator.getImageDescriptor("icons/chart_bar_big.png"));
        super.setDescription(Messages.CHART_WIZARD_BAR_CHART_PAGE_DESCRIPTION);
        this.columnButtons = new HashMap();
    }

    public void handleEvent(Event event) {
        Status status = new Status(0, "Archie", 0, "", null);
        int[] selected = this.getSelectedIndexes();
        if (selected.length <= 0) {
            status = new Status(4, "Archie", 0, Messages.CHART_WIZARD_BAR_CHART_ERROR_ONE_COLUMN, null);
        }
        this.applyToStatusLine((IStatus)status);
        this.getWizard().getContainer().updateButtons();
    }

    @Override
    public void createControl(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
        Composite composite = new Composite((Composite)scrolled, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        SWTUtils.createLabel(composite).setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_CHART_TYPE);
        this.chartType = new Combo(composite, 8);
        this.chartType.add(Messages.CHART_WIZARD_BAR_CHART_BAR_CHART, 0);
        this.chartType.add(Messages.CHART_WIZARD_BAR_CHART_LINE_CHART, 1);
        this.chartType.select(0);
        this.chartType.addListener(13, (Listener)this);
        SWTUtils.createLabel(composite).setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_EXPLANATON);
        this.chartName = new TextWidget(composite, 0, Messages.CHART_WIZARD_BAR_CHART_TEXT_NAME_CHART, null);
        this.chartName.addListener(2, this);
        SWTUtils.createSpacedSeparator(composite, 256);
        DataSet dataset = ((ChartWizard)this.getWizard()).getModel().getDataSet();
        List<String> columns = dataset.getHeadings();
        SWTUtils.createLabel(composite).setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_COLUMN_ROW_LABEL);
        this.rowTitle = new Combo(composite, 8);
        this.rowTitle.setItems(columns.toArray(new String[0]));
        SWTUtils.createLabel(composite).setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_COLUMNS_CATEGORIES);
        this.addButtons(composite, dataset);
        SWTUtils.createSpacedSeparator(composite, 256);
        SWTUtils.createLabel(composite).setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_3D_EXPLANATION);
        this.threeDimensional = new Button(composite, 32);
        this.threeDimensional.setText(Messages.CHART_WIZARD_BAR_CHART_TEXT_3D);
        this.threeDimensional.setToolTipText(Messages.CHART_WIZARD_BAR_CHART_TEXT_3D_TOOLTIP);
        this.threeDimensional.addListener(13, (Listener)this);
        parent.pack();
        Point size = composite.computeSize(-1, -1);
        scrolled.setContent((Control)composite);
        scrolled.setMinHeight(size.y + 100);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        this.initializePreviousModelData();
        this.setControl((Control)scrolled);
    }

    private void addButtons(Composite parent, DataSet dataset) {
        List<String> columns = dataset.getHeadings();
        int index = 0;
        while (index < columns.size()) {
            boolean firstColumn;
            boolean bl = firstColumn = index <= 0;
            if ((DatasetHelper.isNumericColumn(dataset, index) || DatasetHelper.isMoneyColumn(dataset, index)) && !firstColumn) {
                Button columnButton = new Button(parent, 32);
                columnButton.setText(columns.get(index));
                columnButton.addListener(13, (Listener)this);
                this.columnButtons.put(columnButton, new Integer(index));
            }
            ++index;
        }
    }

    private void saveDataToModel() {
        ChartWizard wizard = (ChartWizard)this.getWizard();
        ChartModel chartModel = wizard.getModel();
        int[] indexes = this.getSelectedIndexes();
        int rowTitleIndex = this.rowTitle.getSelectionIndex();
        if (indexes.length > 0) {
            chartModel.setLineChart(this.chartType.getSelectionIndex() == 1);
            chartModel.setColumns(indexes);
            chartModel.setChartName(this.chartName.getValue().toString());
            chartModel.setCategoryColumnIndex(rowTitleIndex > -1 ? rowTitleIndex : 0);
            chartModel.setThreeDimensional(this.threeDimensional.getSelection());
        }
    }

    private void initializePreviousModelData() {
        ChartModelManager manager = ChartModelManager.getInstance();
        if (manager.hasBarChartModel()) {
            ChartModel model = manager.getBarChartModel();
            this.chartName.setValue(model.getChartName());
            this.chartType.select(model.isLineChart() ? 1 : 0);
            this.rowTitle.select(model.getCategoryColumnIndex());
            this.threeDimensional.setSelection(model.isThreeDimensional());
            int[] columns = model.getColumns();
            for (Map.Entry<Button, Integer> entry : this.columnButtons.entrySet()) {
                if (!ArrayUtils.inArray(columns, entry.getValue())) continue;
                entry.getKey().setSelection(true);
            }
        }
    }

    private int getNumberSelected() {
        return this.getSelectedIndexes().length;
    }

    private int[] getSelectedIndexes() {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (Map.Entry<Button, Integer> entry : this.columnButtons.entrySet()) {
            if (!entry.getKey().getSelection()) continue;
            selected.add(entry.getValue());
        }
        int[] indexes = new int[selected.size()];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = (Integer)selected.get(i);
            ++i;
        }
        return indexes;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("ChartWizardMainPage");
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        return this.getWizard().getPage("ContentSelectionPage");
    }

    public boolean canFlipToNextPage() {
        return this.chartName != null && this.chartName.getValue() != null && !this.chartName.getValue().toString().equals("") && this.getErrorMessage() == null && this.getNumberSelected() > 0;
    }
}

