/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.model;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.controller.TreeContentProvider;
import ch.unibe.iam.scg.archie.controller.TreeLabelProvider;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.model.QueryContentProvider;
import ch.unibe.iam.scg.archie.model.QueryLabelProvider;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;

public abstract class AbstractDataProvider
extends Job {
    protected DataSet dataSet = new DataSet();
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private ITreeContentProvider treeContentProvider;

    public AbstractDataProvider(String jobName) {
        super(jobName);
        this.initializeProviders();
        assert (this.labelProvider != null);
        assert (this.contentProvider != null);
    }

    public abstract String getDescription();

    protected abstract List<String> createHeadings();

    protected abstract IStatus createContent(IProgressMonitor var1);

    protected IStatus run(IProgressMonitor monitor) {
        ArchieActivator.LOG.log("Job + " + this.getName(), 4);
        return this.execute(monitor);
    }

    public IStatus execute(IProgressMonitor monitor) {
        this.dataSet.setHeadings(this.createHeadings());
        return this.createContent(monitor);
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    protected void initializeProviders() {
        QueryContentProvider content = new QueryContentProvider(this.dataSet);
        QueryLabelProvider label = new QueryLabelProvider();
        this.setContentProvider(content);
        this.setLabelProvider((ILabelProvider)label);
        if (this.isTree()) {
            TreeContentProvider treeContent = new TreeContentProvider(true);
            treeContent.refreshDataSet(this.dataSet);
            this.setTreeContentProvider(treeContent);
            TreeLabelProvider treeLabel = new TreeLabelProvider(true);
            this.setLabelProvider((ILabelProvider)treeLabel);
        }
    }

    protected void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public boolean isTree() {
        return false;
    }

    protected void setTreeContentProvider(ITreeContentProvider treeContentProvider) {
        this.treeContentProvider = treeContentProvider;
    }

    public ITreeContentProvider getTreeContentProvider() {
        return this.treeContentProvider;
    }
}

