/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.export;

import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.utils.ProviderHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class CSVWriter {
    private static String DELIMITER = ";";

    public static File writeFile(AbstractDataProvider provider, String fileName) throws IOException {
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");
        DataSet data = provider.getDataSet();
        CSVWriter.writeProviderInformation(writer, provider);
        CSVWriter.writeColumnHeadings(writer, data.getHeadings());
        for (Object[] objects : data) {
            CSVWriter.writeRow(writer, objects);
        }
        writer.close();
        return file;
    }

    private static void writeColumnHeadings(OutputStreamWriter writer, List<String> headings) throws IOException {
        Object[] objects = headings.toArray();
        CSVWriter.writeRow(writer, objects);
    }

    private static void writeProviderInformation(OutputStreamWriter writer, AbstractDataProvider provider) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        writer.write(provider.getName() + "\n");
        writer.write(dateFormat.format(Calendar.getInstance().getTime()) + "\n\n");
        Map<String, Object> getters = ProviderHelper.getGetterMap(provider, true);
        Object[] objectArray = getters.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            writer.write(String.valueOf(name) + " = " + String.valueOf(getters.get(name)) + "\n");
            ++n2;
        }
        writer.write("\n\n");
    }

    private static void writeRow(OutputStreamWriter writer, Object[] objects) throws IOException {
        StringBuffer buf = new StringBuffer();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            buf.append(obj != null ? obj.toString() : "");
            buf.append(DELIMITER);
            ++n2;
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("\n");
        writer.write(buf.toString());
    }
}

