/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.views;

import ch.elexis.core.model.IUser;
import ch.elexis.core.ui.UiDesk;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.acl.ArchieACL;
import ch.unibe.iam.scg.archie.actions.CreateChartsAction;
import ch.unibe.iam.scg.archie.actions.RefreshChartsAction;
import ch.unibe.iam.scg.archie.model.MutexRule;
import ch.unibe.iam.scg.archie.ui.DashboardOverview;
import ch.unibe.iam.scg.archie.ui.GraphicalMessage;
import ch.unibe.iam.scg.archie.ui.charts.AbstractChartComposite;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import ch.unibe.iam.scg.archie.ui.charts.AgeHistogrammChart;
import ch.unibe.iam.scg.archie.ui.charts.ConsultationMoneyChart;
import ch.unibe.iam.scg.archie.ui.charts.ConsultationNumberChart;
import ch.unibe.iam.scg.archie.ui.charts.PatientsConsHistChart;
import jakarta.inject.Inject;
import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class Dashboard
extends ViewPart
implements IJobChangeListener {
    public static final String ID = "ch.unibe.iam.scg.archie.ui.views.Dashboard";
    private ArrayList<AbstractChartComposite> charts = new ArrayList(4);
    private Composite container;
    private DashboardOverview overview;
    private Composite bottomPart;
    private Composite chartsNotCreatedMessage;
    private int jobCounter = 0;
    private RefreshChartsAction refreshChartsAction;
    private CreateChartsAction createChartsAction;

    private void initialize() {
        if (ArchieACL.userHasAccess()) {
            this.initializeParts();
            this.initializeChartsNotCreatedMessage();
        } else {
            this.cancelAllCreators();
            this.initializeAccessDisabled();
        }
        this.container.layout();
    }

    private void addActions() {
        this.createChartsAction = new CreateChartsAction(this);
        this.refreshChartsAction = new RefreshChartsAction(this);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)this.createChartsAction);
        manager.add((IAction)this.refreshChartsAction);
    }

    private void cancelAllCreators() {
        for (AbstractChartComposite chart : this.charts) {
            chart.cancelCreator();
        }
    }

    private void initializeCharts() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        this.bottomPart.setLayout((Layout)layout);
        this.bottomPart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.charts.add(new ConsultationNumberChart(this.bottomPart, 0));
        this.charts.add(new ConsultationMoneyChart(this.bottomPart, 0));
        this.charts.add(new PatientsConsHistChart(this.bottomPart, 0));
        this.charts.add(new AgeHistogrammChart(this.bottomPart, 0));
        for (AbstractChartComposite chart : this.charts) {
            chart.addJobChangeListener(this);
        }
        this.bottomPart.layout();
    }

    private void initializeAccessDisabled() {
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        new GraphicalMessage(this.container, ArchieActivator.getImage("error"), Messages.ACL_ACCESS_DENIED);
    }

    private void initializeParts() {
        this.overview = new DashboardOverview(this.container, 0);
        this.bottomPart = new Composite(this.container, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bottomPart.setLayout((Layout)layout);
        this.bottomPart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.overview.setLayout((Layout)layout);
        this.overview.setLayoutData(new GridData(4, 4, true, false));
        assert (this.overview != null);
        assert (this.bottomPart != null);
    }

    private void initializeChartsNotCreatedMessage() {
        assert (this.bottomPart != null);
        this.chartsNotCreatedMessage = new GraphicalMessage(this.bottomPart, ArchieActivator.getImage("info"), Messages.DASHBOARD_CHARTS_NOT_CREATED);
    }

    private void clearChartsNotCreatedMessage() {
        if (this.chartsNotCreatedMessage != null && !this.chartsNotCreatedMessage.isDisposed()) {
            this.chartsNotCreatedMessage.dispose();
        }
    }

    public void redrawCharts() {
        this.jobCounter = 0;
        for (AbstractChartComposite chart : this.charts) {
            chart.refresh();
        }
    }

    public void updateOverview() {
        this.overview.refresh();
    }

    public void createCharts() {
        this.clearChartsNotCreatedMessage();
        this.initializeCharts();
        MutexRule rule = new MutexRule();
        for (AbstractChartComposite chart : this.charts) {
            AbstractDatasetCreator creator = chart.getCreator();
            creator.setRule(rule);
            creator.schedule();
        }
    }

    public void createPartControl(Composite composite) {
        this.container = composite;
        this.addActions();
        this.initialize();
    }

    private void userChanged() {
        this.jobCounter = 0;
        for (AbstractChartComposite chart : this.charts) {
            chart.removeJobChangeListener(this);
        }
        this.charts.clear();
        UiDesk.getDisplaySafe().ifPresent(d -> d.syncExec(() -> {
            if (this.container != null) {
                Control[] controlArray = this.container.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
            }
            this.initialize();
        }));
        this.refreshChartsAction.setEnabled(false);
        this.createChartsAction.setEnabled(true);
    }

    public void done(IJobChangeEvent event) {
        UiDesk.getDisplaySafe().ifPresent(d -> d.syncExec(() -> this.refreshChartsAction.setEnabled(++this.jobCounter == this.charts.size())));
    }

    public void scheduled(IJobChangeEvent event) {
        UiDesk.getDisplaySafe().ifPresent(d -> d.syncExec(() -> this.createChartsAction.setEnabled(false)));
    }

    public void setFocus() {
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> this.userChanged());
    }
}

