/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jfree.data.general.DefaultPieDataset;

public class PatientDatasetCreator
extends AbstractDatasetCreator {
    public PatientDatasetCreator(String jobName) {
        super(jobName);
    }

    @Override
    public IStatus createContent(IProgressMonitor monitor) {
        Query patientQuery = new Query(Patient.class);
        HashMap<String, Integer> patientsMap = new HashMap<String, Integer>();
        List patients = patientQuery.execute();
        monitor.beginTask("Querying Database", patients.size());
        for (Patient patient : patients) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String gender = patient.getGeschlecht();
            if (gender.equals("m") || gender.equals("w")) {
                if (patientsMap.containsKey(gender)) {
                    Integer count = (Integer)patientsMap.get(gender);
                    patientsMap.put(gender, new Integer(count + 1));
                } else {
                    patientsMap.put(gender, 1);
                }
            }
            monitor.worked(1);
        }
        this.dataset = new DefaultPieDataset();
        for (Map.Entry entry : patientsMap.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ((DefaultPieDataset)this.dataset).setValue((Comparable)entry.getKey(), (Number)entry.getValue());
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

