/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class ConsultationNumberDatasetCreator
extends AbstractDatasetCreator {
    private static final String DATE_DB_FORMAT = "yyyyMMdd";
    private static final String DATE_CONS_FORMAT = "dd.MM.yyyy";
    private boolean isEmpty = true;

    public ConsultationNumberDatasetCreator(String jobName) {
        super(jobName);
    }

    @Override
    public IStatus createContent(IProgressMonitor monitor) {
        SimpleDateFormat databaseFormat = new SimpleDateFormat(DATE_DB_FORMAT);
        SimpleDateFormat consultationFormat = new SimpleDateFormat(DATE_CONS_FORMAT);
        Query query = new Query(Konsultation.class);
        Calendar now = Calendar.getInstance();
        now.add(2, -1);
        now.set(5, now.getMaximum(5));
        Calendar before = Calendar.getInstance();
        before.add(2, -7);
        before.set(5, before.getMinimum(5));
        query.add("Datum", ">=", databaseFormat.format(before.getTime()));
        query.add("Datum", "<", databaseFormat.format(now.getTime()));
        query.add("MandantID", "=", CoreHub.actMandant.getId());
        monitor.subTask("querying database");
        List consults = query.execute();
        this.isEmpty = consults.size() <= 0;
        monitor.beginTask("doing calculations", query.size() * 2);
        TreeMap consultsMap = new TreeMap();
        for (Konsultation consult : consults) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                Date date = consultationFormat.parse(consult.getDatum());
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                Month month = new Month(cal.get(2) + 1, cal.get(1));
                if (consultsMap.containsKey(month)) {
                    ((ArrayList)consultsMap.get(month)).add(consult);
                } else {
                    ArrayList<Konsultation> consultList = new ArrayList<Konsultation>(1);
                    consultList.add(consult);
                    consultsMap.put(month, consultList);
                }
                monitor.worked(1);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        TimeSeries countSeries = new TimeSeries((Comparable)((Object)"Count"), Month.class);
        for (Map.Entry entry : consultsMap.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Month month = (Month)entry.getKey();
            int count = 0;
            monitor.worked(((ArrayList)entry.getValue()).size());
            countSeries.add((RegularTimePeriod)month, (double)(count += ((ArrayList)entry.getValue()).size()));
        }
        this.dataset = new TimeSeriesCollection();
        ((TimeSeriesCollection)this.dataset).addSeries(countSeries);
        monitor.done();
        return Status.OK_STATUS;
    }

    @Override
    protected boolean isDatasetEmpty() {
        return this.isEmpty;
    }
}

