/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class ConsultationMoneyDatasetCreator
extends AbstractDatasetCreator {
    private static final String DATE_DB_FORMAT = "yyyyMMdd";
    private static final String DATE_CONS_FORMAT = "dd.MM.yyyy";
    private boolean isEmpty = true;

    public ConsultationMoneyDatasetCreator(String jobName) {
        super(jobName);
    }

    @Override
    public IStatus createContent(IProgressMonitor monitor) {
        SimpleDateFormat databaseFormat = new SimpleDateFormat(DATE_DB_FORMAT);
        SimpleDateFormat consultationFormat = new SimpleDateFormat(DATE_CONS_FORMAT);
        Query query = new Query(Konsultation.class);
        Calendar now = Calendar.getInstance();
        now.add(2, -1);
        now.set(5, now.getMaximum(5));
        Calendar before = Calendar.getInstance();
        before.add(2, -7);
        before.set(5, before.getMinimum(5));
        query.add("Datum", ">=", databaseFormat.format(before.getTime()));
        query.add("Datum", "<", databaseFormat.format(now.getTime()));
        query.add("MandantID", "=", CoreHub.actMandant.getId());
        monitor.subTask("querying database");
        List consults = query.execute();
        this.isEmpty = consults.size() <= 0;
        monitor.beginTask("doing calculations", query.size() * 2);
        TreeMap consultsMap = new TreeMap();
        for (Konsultation consult : consults) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                Date date = consultationFormat.parse(consult.getDatum());
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                Month month = new Month(cal.get(2) + 1, cal.get(1));
                if (consultsMap.containsKey(month)) {
                    ((ArrayList)consultsMap.get(month)).add(consult);
                } else {
                    ArrayList<Konsultation> consultList = new ArrayList<Konsultation>(1);
                    consultList.add(consult);
                    consultsMap.put(month, consultList);
                }
                monitor.worked(1);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        TimeSeries profitSeries = new TimeSeries((Comparable)((Object)"Profit"), Month.class);
        TimeSeries spendingSeries = new TimeSeries((Comparable)((Object)"Spending"), Month.class);
        TimeSeries incomeSeries = new TimeSeries((Comparable)((Object)"Income"), Month.class);
        for (Map.Entry entry : consultsMap.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Month month = (Month)entry.getKey();
            double profit = 0.0;
            double spending = 0.0;
            double income = 0.0;
            for (Konsultation consult : (ArrayList)entry.getValue()) {
                profit += consult.getGewinn();
                spending += (double)consult.getKosten();
                income += consult.getUmsatz();
                monitor.worked(1);
            }
            profitSeries.add((RegularTimePeriod)month, profit / 100.0);
            spendingSeries.add((RegularTimePeriod)month, spending / 100.0);
            incomeSeries.add((RegularTimePeriod)month, income / 100.0);
        }
        this.dataset = new TimeSeriesCollection();
        ((TimeSeriesCollection)this.dataset).addSeries(profitSeries);
        ((TimeSeriesCollection)this.dataset).addSeries(spendingSeries);
        ((TimeSeriesCollection)this.dataset).addSeries(incomeSeries);
        monitor.done();
        return Status.OK_STATUS;
    }

    @Override
    protected boolean isDatasetEmpty() {
        return this.isEmpty;
    }
}

