/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.model;

public class Cohort
implements Comparable<Cohort> {
    public static final String TITLE_DELIMITER = " - ";
    private int lowerBound;
    private int upperBound;
    private Object value;

    public Cohort(int lowerBound, int upperBound, Object value) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("lowerBound has to be smaller than upperBound!");
        }
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setValue(value);
    }

    public int getCohortSize() {
        return Math.abs(this.upperBound - this.lowerBound) + 1;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.lowerBound == this.upperBound) {
            return Integer.valueOf(this.lowerBound).toString();
        }
        return this.lowerBound + TITLE_DELIMITER + this.upperBound;
    }

    @Override
    public int compareTo(Cohort otherCohort) {
        if (this.lowerBound == otherCohort.getLowerBound()) {
            if (this.getCohortSize() < otherCohort.getCohortSize()) {
                return -1;
            }
            if (this.getCohortSize() > otherCohort.getCohortSize()) {
                return 1;
            }
            return 0;
        }
        if (this.lowerBound < otherCohort.getLowerBound()) {
            return -1;
        }
        if (this.lowerBound > otherCohort.getLowerBound()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        Cohort otherCohort;
        return object instanceof Cohort && this.lowerBound == (otherCohort = (Cohort)object).getLowerBound() && this.upperBound == otherCohort.getUpperBound();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

