/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.model;

import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.SetDataException;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractTimeSeries
extends AbstractDataProvider {
    private Calendar startDate;
    private Calendar endDate;

    public AbstractTimeSeries(String name) {
        super(name);
        this.initDates();
    }

    private void initDates() {
        this.setStartDate(Calendar.getInstance());
        this.getStartDate().set(this.getStartDate().get(1), 0, 1);
        this.setEndDate(Calendar.getInstance());
        this.getEndDate().set(this.getEndDate().get(1), 11, 31);
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    @GetProperty(name="Start Date", index=-2, widgetType=WidgetTypes.TEXT_DATE, validationRegex="\\d{2}\\.\\d{2}\\.\\d{4}", validationMessage="The date needs to have the following format: dd.MM.yyyy")
    public String metaGetStartDate() {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        return format.format(this.getStartDate().getTime());
    }

    @SetProperty(name="Start Date", index=-2)
    public void metaSetStartDate(String startDate) throws SetDataException {
        Calendar cal;
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            Date date = format.parse(startDate);
            cal = Calendar.getInstance();
            cal.setTime(date);
            cal.get(5);
            cal.get(2);
            cal.get(1);
        }
        catch (ParseException e) {
            throw new SetDataException(NLS.bind((String)Messages.ERROR_SET_START_DATE, (Object)"dd.MM.yyyy"));
        }
        catch (IllegalArgumentException e) {
            throw new SetDataException(Messages.ERROR_START_DATE_VALID);
        }
        this.setStartDate(cal);
    }

    @GetProperty(name="End Date", widgetType=WidgetTypes.TEXT_DATE, validationRegex="\\d{2}\\.\\d{2}\\.\\d{4}", validationMessage="Datumsformat blubb...")
    public String metaGetEndDate() {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        return format.format(this.getEndDate().getTime());
    }

    @SetProperty(name="End Date")
    public void metaSetEndDate(String endDate) throws SetDataException {
        Calendar cal;
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            Date date = format.parse(endDate);
            cal = Calendar.getInstance();
            cal.setTime(date);
            cal.get(5);
            cal.get(2);
            cal.get(1);
        }
        catch (ParseException e) {
            throw new SetDataException(NLS.bind((String)Messages.ERROR_SET_END_DATE, (Object)"dd.MM.yyyy"));
        }
        catch (IllegalArgumentException e) {
            throw new SetDataException(Messages.ERROR_END_DATE_VALID);
        }
        if (cal.compareTo(this.getStartDate()) < 0) {
            throw new SetDataException(Messages.ERROR_DATE_DIFFERENCE);
        }
        this.setEndDate(cal);
    }
}

