/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.controller;

import ch.unibe.iam.scg.archie.model.ColumnSorterAdapter;
import ch.unibe.iam.scg.archie.model.DataSet;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableFactory {
    private static TableFactory INSTANCE = null;

    private TableFactory() {
    }

    public static final TableFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TableFactory();
        }
        return INSTANCE;
    }

    public TableViewer createTableFromData(Composite parent, DataSet dataset, ILabelProvider labelProvider, IContentProvider contentProvider) {
        Table table = this.createTable(parent, dataset);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        tableViewer.setContentProvider(contentProvider);
        tableViewer.setInput((Object)table);
        this.addColumnSort(tableViewer);
        return tableViewer;
    }

    private Table createTable(Composite parent, DataSet dataset) {
        Table table = new Table(parent, 66306);
        TableColumnLayout tableLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(table, dataset, tableLayout);
        return table;
    }

    private void createColumns(Table table, DataSet dataset, TableColumnLayout layout) {
        int i = 0;
        List<String> headings = dataset.getHeadings();
        for (String text : headings) {
            TableColumn column = new TableColumn(table, 0);
            column.setMoveable(true);
            column.setText(text);
            column.pack();
            int weight = Math.round(100 / headings.size());
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
            ++i;
        }
    }

    private void addColumnSort(TableViewer viewer) {
        TableColumn[] cols = viewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].addSelectionListener((SelectionListener)new ColumnSorterAdapter(viewer, i));
            ++i;
        }
    }
}

