/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.tests;

import ch.rgw.tools.Money;
import ch.unibe.iam.scg.archie.model.DataSet;
import ch.unibe.iam.scg.archie.utils.DatasetHelper;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;

public class DatasetHelperTest {
    private DataSet sampleDataSet;
    private ArrayList<String> sampleHeadings = new ArrayList();
    private ArrayList<Comparable<?>[]> sampleContent = new ArrayList();
    private Comparable<?>[] sampleRow1 = new Comparable[]{"Hans", Integer.valueOf(24), new Money(3500.7), Double.valueOf(0.03)};
    private Comparable<?>[] sampleRow2 = new Comparable[]{"Vreni", Integer.valueOf(16), new Money(6400.0), Double.valueOf(0.12)};
    private Comparable<?>[] sampleRow3 = new Comparable[]{"Jakob", Integer.valueOf(54), new Money(7891.23), Double.valueOf(0.98)};

    @Before
    public void setUp() {
        this.sampleHeadings.add("First Name");
        this.sampleHeadings.add("Age");
        this.sampleHeadings.add("Salary");
        this.sampleHeadings.add("Happyness");
        this.sampleContent.add(this.sampleRow1);
        this.sampleContent.add(this.sampleRow2);
        this.sampleContent.add(this.sampleRow3);
        this.sampleDataSet = new DataSet(this.sampleContent, this.sampleHeadings);
    }

    @org.junit.Test
    public void testSortingDataset() {
        DataSet clonedDataset = this.sampleDataSet.clone();
        Assert.assertEquals((Object)"Hans", clonedDataset.getCell(0, 0));
        Assert.assertEquals((Object)"Vreni", clonedDataset.getCell(1, 0));
        Assert.assertEquals((Object)"Jakob", clonedDataset.getCell(2, 0));
        DatasetHelper.sortDataSet(clonedDataset, "First Name", 128);
        Assert.assertEquals((Object)"Hans", clonedDataset.getCell(0, 0));
        Assert.assertEquals((Object)"Jakob", clonedDataset.getCell(1, 0));
        Assert.assertEquals((Object)"Vreni", clonedDataset.getCell(2, 0));
        DatasetHelper.sortDataSet(clonedDataset, "First Name", 1024);
        Assert.assertEquals((Object)"Vreni", clonedDataset.getCell(0, 0));
        Assert.assertEquals((Object)"Jakob", clonedDataset.getCell(1, 0));
        Assert.assertEquals((Object)"Hans", clonedDataset.getCell(2, 0));
        DatasetHelper.sortDataSet(clonedDataset, "Salary", 1024);
        Assert.assertEquals((Object)new Money(7891.23), clonedDataset.getCell(0, 2));
        Assert.assertEquals((Object)new Money(6400.0), clonedDataset.getCell(1, 2));
        Assert.assertEquals((Object)new Money(3500.7), clonedDataset.getCell(2, 2));
    }

    @org.junit.Test
    public void testNumericColumns() {
        DataSet dataset = this.sampleDataSet;
        Assert.assertFalse((boolean)DatasetHelper.isNumericColumn(dataset, 0));
        Assert.assertTrue((boolean)DatasetHelper.isNumericColumn(dataset, 1));
        Assert.assertFalse((boolean)DatasetHelper.isNumericColumn(dataset, 2));
        Assert.assertTrue((boolean)DatasetHelper.isMoneyColumn(dataset, 2));
        Assert.assertTrue((boolean)DatasetHelper.isNumericColumn(dataset, 3));
        Assert.assertFalse((boolean)DatasetHelper.isNumericColumn(dataset, "First Name"));
        Assert.assertTrue((boolean)DatasetHelper.isNumericColumn(dataset, "Age"));
        Assert.assertFalse((boolean)DatasetHelper.isNumericColumn(dataset, "Salary"));
        Assert.assertTrue((boolean)DatasetHelper.isMoneyColumn(dataset, "Salary"));
        Assert.assertTrue((boolean)DatasetHelper.isNumericColumn(dataset, "Happyness"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DatasetHelperTest.class);
    }
}

