/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.tests;

import ch.unibe.iam.scg.archie.model.Cohort;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Before;

public class CohortTest {
    private Cohort cohort;
    private Cohort cohortSame;
    private Cohort cohortSmall;
    private Cohort cohortLarge;
    private Cohort cohortStrange;

    @Before
    public void setUp() {
        this.cohort = new Cohort(5, 30, "Hello World");
        this.cohortSame = new Cohort(5, 30, "Something else");
        this.cohortSmall = new Cohort(10, 15, new Integer(3));
        this.cohortLarge = new Cohort(10, 30, new Integer(5));
        this.cohortStrange = new Cohort(-30, -10, this.cohort);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testConstructor() {
        new Cohort(-5, -10, "Preconditions not satisfied!");
        new Cohort(45, 13, "Preconditions not satisfied!");
        new Cohort(9, -1, "Preconditions not satisfied!");
    }

    @org.junit.Test
    public void testCompareTo() {
        Assert.assertEquals((int)this.cohortSmall.compareTo(this.cohortLarge), (int)-1);
        Assert.assertEquals((int)this.cohortLarge.compareTo(this.cohortSmall), (int)1);
        Assert.assertEquals((int)this.cohortLarge.compareTo(this.cohortLarge), (int)0);
        ArrayList<Cohort> cohorts = new ArrayList<Cohort>(5);
        cohorts.add(this.cohort);
        cohorts.add(this.cohortSame);
        cohorts.add(this.cohortStrange);
        cohorts.add(this.cohortLarge);
        cohorts.add(this.cohortSmall);
        Collections.sort(cohorts);
        Assert.assertTrue((boolean)((Cohort)cohorts.get(0)).equals(this.cohortStrange));
        Assert.assertTrue((boolean)((Cohort)cohorts.get(1)).equals(this.cohortSame));
        Assert.assertTrue((boolean)((Cohort)cohorts.get(2)).equals(this.cohort));
        Assert.assertTrue((boolean)((Cohort)cohorts.get(3)).equals(this.cohortSmall));
        Assert.assertTrue((boolean)((Cohort)cohorts.get(4)).equals(this.cohortLarge));
    }

    @org.junit.Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.cohort.equals(this.cohort));
        Assert.assertTrue((boolean)this.cohortStrange.getValue().equals(this.cohort));
        Assert.assertTrue((boolean)this.cohort.equals(this.cohortSame));
        Assert.assertFalse((boolean)this.cohort.equals(this.cohortLarge));
        Assert.assertFalse((boolean)this.cohort.equals(this.cohortSmall));
    }

    @org.junit.Test
    public void testGettersAndSetters() {
        Assert.assertEquals((int)this.cohort.getCohortSize(), (int)26);
        Assert.assertEquals((int)this.cohort.getLowerBound(), (int)5);
        Assert.assertEquals((int)this.cohort.getUpperBound(), (int)30);
        Assert.assertEquals((Object)this.cohort.getValue(), (Object)"Hello World");
        Assert.assertEquals((String)this.cohort.toString(), (String)"5 - 30");
        this.cohort.setLowerBound(7);
        this.cohort.setUpperBound(12);
        this.cohort.setValue("Another String");
        Assert.assertEquals((int)this.cohort.getCohortSize(), (int)6);
        Assert.assertEquals((int)this.cohort.getLowerBound(), (int)7);
        Assert.assertEquals((int)this.cohort.getUpperBound(), (int)12);
        Assert.assertEquals((Object)this.cohort.getValue(), (Object)"Another String");
        Assert.assertEquals((String)this.cohort.toString(), (String)"7 - 12");
        this.cohort.setLowerBound(2);
        this.cohort.setUpperBound(2);
        Assert.assertEquals((String)this.cohort.toString(), (String)"2");
        Assert.assertEquals((int)this.cohort.getCohortSize(), (int)1);
        Assert.assertEquals((int)this.cohortStrange.getCohortSize(), (int)21);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(CohortTest.class);
    }
}

