/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.ui.charts.AbstractChartComposite;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import ch.unibe.iam.scg.archie.ui.charts.AgeHistogrammDatasetCreator;
import ch.unibe.iam.scg.archie.ui.charts.HistogramTooltipGenerator;
import java.awt.Color;
import java.awt.Paint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class AgeHistogrammChart
extends AbstractChartComposite {
    private static final String CHART_TITLE = "Age Histogram";

    public AgeHistogrammChart(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected JFreeChart initializeChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)CHART_TITLE, (String)"Age", (String)"Patients", (CategoryDataset)((DefaultKeyedValues2DDataset)this.creator.getDataset()), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)new HistogramTooltipGenerator());
        CategoryAxis axis = plot.getDomainAxis();
        axis.setTickLabelsVisible(false);
        chart.setBackgroundPaint((Paint)new Color(this.parent.getBackground().getRed(), this.parent.getBackground().getGreen(), this.parent.getBackground().getBlue()));
        return chart;
    }

    @Override
    protected AbstractDatasetCreator initializeCreator() {
        return new AgeHistogrammDatasetCreator(CHART_TITLE, this.getCohortSize());
    }

    @Override
    public void refresh() {
        super.refresh();
        ((AgeHistogrammDatasetCreator)this.creator).setCohortSize(this.getCohortSize());
    }

    private int getCohortSize() {
        IPreferenceStore preferences = ArchieActivator.getInstance().getPreferenceStore();
        if (preferences.getInt("archieCohortSize") > 0) {
            return preferences.getInt("archieCohortSize");
        }
        return 5;
    }
}

